# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case

    setup()         --  Setup function of this test case

    deletepair()    --  Delete Replication pair

    pair_status()   -- To get Blr pair status

    get_browse_mount_point()  -- To get  Browse mount guid

    create_fsblr_granularreplication_pair() --  Create fsblr granular pair

    create_granular_replica_copy() -- Create Granular permananent mount

"""
import os
import time
from AutomationUtils import logger, constants, machine
from AutomationUtils.cvtestcase import CVTestCase
from FileSystem.FSUtils.fshelper import FSHelper


class TestCase(CVTestCase):
    """Class for executing live mount"""
    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()

        self.name = "BLR Granular Replication Validation"
        self.applicable_os = self.os_list.WINDOWS
        self.product = self.products_list.FILESYSTEM
        self.feature = self.features_list.DATAPROTECTION
        self.show_to_user = True
        self.test_path = ""
        self.slash_format = ""
        self.client_machine = None
        self.dest_client_obj = None
        self.runid = ""
        self.rpstoreid = ""
        self.tcinputs = {
            "srcclient": "string",
            "destclient": "string",
            "srcvol": "string",
            "destvol": "string",
            "RestorePath" : None,
            "RPStore": None
        }
        self.srcclient = self.tcinputs['srcclient']
        self.destclient = self.tcinputs['destclient']
        self.srcvol = self.tcinputs['srcvol']
        self.destvol = self.tcinputs['destvol']
        self.restorepath = self.tcinputs['RestorePath']
        self.rpstore = self.tcinputs['RPStore']
        self.dest_clientid = None
        self.src_clientid = None
        self.scid = None
        self.blrid = None
        self.rpstore = None
        self.subclient_name = None
        self.dstguid = None
        self.restoreguid = None
        self.srcguid = None
        self.destguid = None
        self.status = None
        self.subclient_name = None
        self.result_string = None
        self.replication_type = 4
        self.subclientcontent = list()

    def setup(self):
        """Setup function for testcase execution  """
        self.srcclient = self.tcinputs['srcclient']
        self.destclient = self.tcinputs['destclient']
        self.srcvol = self.tcinputs['srcvol']
        self.destvol = self.tcinputs['destvol']
        self.restorepath = self.tcinputs['RestorePath']
        self.rpstore = self.tcinputs['RPStore']

    def run(self):
        """Main function for test case execution"""
        try:
            self.helper = FSHelper(TestCase)
            self.tcinputs.update({"BackupsetName": "defaultBackupSet"})
            self.tcinputs.update({"AgentName": "File System"})

            FSHelper.populate_tc_inputs(self, mandatory=False)
            slash_format = self.slash_format
            subclient_content = []
            subclient_content.append(self.srcvol)
            run_path = ("%s%s%s" % (subclient_content[0], slash_format, str(self.runid)))
            full_data_path = ("%s%sfull" % (run_path, slash_format))
            self.log.info("source_data_path = {}".format(full_data_path))
            self.log.info(self._commcell)
            backupset_name = "defaultBackupSet"
            self.helper.create_backupset(backupset_name, delete=False)
            if self._instance is None:
                self._backupset = self._agent.backupsets.get(
                    self.tcinputs['BackupsetName']
                )
            else:
                self._backupset = self._instance.backupsets.get(
                    self.tcinputs['BackupsetName']
                )
            drive_tail = os.path.splitdrive(full_data_path)
            restore_data_path = self.restorepath+drive_tail[1]
            self.log.info("restorepath =  %s" %(restore_data_path))
            self.dest_client_obj = self.commcell.clients.get(self.tcinputs['destclient'])

            if self.dest_client_obj is not None and 'AgentName' in self.tcinputs:
                self.log.info("Create agent object for: %s", self.tcinputs['AgentName'])
                self.dest_agent_obj = self.dest_client_obj.agents.get(self.tcinputs['AgentName'])

            if 'BackupsetName' in self.tcinputs:
                self.log.info("Creating backupset object for: %s",
                              self.tcinputs['BackupsetName'])
                self.dest_backupset = self.dest_agent_obj.backupsets.get(
                    self.tcinputs['BackupsetName']
                )
            self.dest_clientid = int(self.dest_client_obj.client_id)
            self.src_clientid = int(self._client.client_id)

            self.srcguid = self.get_browse_mount_point(self.backupset, self.srcvol)
            self.destguid = self.get_browse_mount_point(self.dest_backupset, self.destvol)
            self.restoreguid = self.get_browse_mount_point(self.dest_backupset, self.restorepath)

            query = "select RPStoreId from MMRPStoreConfig where RPStoreName = '{}'"\
                .format(self.rpstore)
            self.csdb.execute(query)
            _results1 = self.csdb.fetch_all_rows()
            self.rpstoreid = int(_results1[0][0])

            self.log.info("Start Creating FSBLR Pair ")
            self.create_fsblr_granularreplication_pair()
            self.log.info("Created FSBLR pair")
            time.sleep(60)

            for i in range(3):
                fullcontent_data_path = ("%s%s%s" % (full_data_path, slash_format, str(i)))
                self.client_machine.generate_test_data(
                    fullcontent_data_path
                )
                self.log.info("Added test data {}".format(fullcontent_data_path))
                self.log.info(" <<<<<< Sleeping for 200secs to let copy happen >>>>>>")
                time.sleep(200)

                self.subclient_name = "BLRSC_" + self.srcclient + "_" + self.destclient +\
                                      "_" + self.srcvol
                self.log.info("Created FSBLR pair: {}".format(self.subclient_name))

                query = "select id from APP_application where subclientName like  '{}'"\
                    .format(self.subclient_name)
                self.csdb.execute(query)
                _results2 = self.csdb.fetch_all_rows()
                self.scid = int(_results2[0][0])
                query = "select id, srcguid, dstGuid from BlrPair where subClientId ={}"\
                    .format(self.scid)
                self.csdb.execute(query)
                _results3 = self.csdb.fetch_all_rows()
                self.blrid = int(_results3[0][0])
                self.dstguid = _results3[0][2]

                self.log.info("Waiting until pair in replicating state")
                while not self.pair_status():
                    time.sleep(60)

                self.log.info("blr id : %s , subclientid : %s" %(self.blrid, self.scid))
                self.log.info("Start Creating Replica copy/ permanent Mount ")
                self.create_granular_replica_copy()
                self.log.info("Created Replica copy/ permanent Mount ")

                self.subclientcontent = list()
                self.subclientcontent.append(self.srcvol)
                destination_machine = machine.Machine(self.dest_client_obj, self._commcell)
                self.log.info("Comparing source path {0} , restore path {1} "
                              .format(full_data_path, restore_data_path))
                diff_output = self.client_machine.compare_folders(
                    destination_machine, full_data_path, restore_data_path)
                if len(diff_output) == 0:
                    self.log.info("Checksum comparison successful")
                else:
                    self.log.error("Checksum comparison failed")
                    self.log.info("Diff output: \n%s", diff_output)
                    raise Exception("Checksum comparison failed")
            self.status = constants.PASSED
            self.deletepair(self.blrid)
            self.log.info(" TestCase Passed ...!! cleaning up ...")
            time.sleep(300)
            self.client_machine.remove_directory(run_path)

        except Exception as exp:
            self.log.exception(f'Testcase failed with exception:{exp}')
            self._result_string = str(exp)
            self._status = constants.FAILED

    def deletepair(self, blrid):
        """Deleting BLR Pair"""
        self.backupset.delete_replication_pair(blrid)
        self.log.info("BLR PAIR DELETED")

    def pair_status(self):
        """To Fetch Replication status on pair"""


        query = "select statusCode from BlrPair where subClientId ={}".format(self.scid)
        self.csdb.execute(query)
        _results5 = self.csdb.fetch_all_rows()
        self.status = int(_results5[0][0])

        if self.status == 4:
            self.log.info("PAIR IN REPLICATING STATE")
            return True
        return False


    def create_fsblr_granularreplication_pair(self):
        """Creates a BLR Pair"""
        self.backupset.create_fsblr_replication_pair(self.src_clientid, self.dest_clientid,
                                                     self.srcguid, self.destguid, self.rpstoreid,
                                                     self.replication_type, **self.tcinputs)
        self.log.info("Created BLR Pair")

    def create_granular_replica_copy(self, wait_to_complete=True):
        """Creates permanent mount of replicated volume and does restore """
        try:
            self.log.info(" Running Permananent Mount")
            job = self.backupset.create_granular_replica_copy(self.src_clientid, self.dest_clientid,
                                                              self.scid, self.blrid, self.dstguid, self.destguid,
                                                              self.restoreguid, **self.tcinputs)
            self.log.info("Started restore in place job with job id: %s", job.job_id)

            if wait_to_complete:

                if not job.wait_for_completion():
                    raise Exception(
                        "Failed to run restore in place job with error: {0}".format(
                            job.delay_reason))

                if not job.status.lower() == "completed":
                    raise Exception(
                        "Job status is not Completed, job has status: {0}".format(
                            job.status))

                self.log.info("Successfully finished restore in place job")
                return job
            return job

        except Exception as exp:
            self.log.error('Job error : %s', str(exp))
            raise Exception('Job error : {0}'.format(str(exp)))

    def get_browse_mount_point(self, backupset_obj, volume):
        """To get browse Mount points Guid """

        try:
            self.log.info(" Getting Browse volume information ")

            volume_list = backupset_obj.get_browse_volume_guid()
            for i in range(len(volume_list['mountPathInfo'])):
                if volume_list['mountPathInfo'][i]['accessPathList'][0] == volume:
                    self.log.info(volume_list['mountPathInfo'][i]['guid'])
                    return volume_list['mountPathInfo'][i]['guid']

        except Exception as excp:
            self.log.error('Job error : %s', str(excp))
            raise Exception('Job error : {0}'.format(str(excp)))
