# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

import time
from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import VsaTestCaseUtils, VirtualServerUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of Amazon V2 backup and Restore test case with
    Incremental v2 Snap backup and backup copy"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "AMAZON : V2: Incremental Snap and backup copy (VPC) and File" \
                    "level restore and Full VM restore (VPC)"
        self.tc_utils = VsaTestCaseUtils.VSATestCaseUtils(self,
                                                          self.products_list.VIRTUALIZATIONVMWARE,
                                                          self.features_list.DATAPROTECTION)

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = VirtualServerUtils.subclient_initialize(self)
            self.tc_utils.assign_sub_client(auto_subclient)
            backup_options = self.tc_utils.run_backup(self, msg='Full v2 Incremental Snap Backup and Backup Copy',
                                                      advance_options={"create_backup_copy_immediately": True},
                                                      backup_method='SNAP',
                                                      backup_type='INCREMENTAL')

            vm_restore_options = self.tc_utils. \
                run_virtual_machine_restore(self,
                                            power_on_after_restore=True,
                                            browse_from_snap=True,
                                            unconditional_overwrite=True,
                                            msg='FULL VM out of place restore from parent from snap')

            vm_restore_options = self.tc_utils. \
                run_virtual_machine_restore(self,
                                            power_on_after_restore=True,
                                            browse_from_snap=False,
                                            browse_from_backup_copy=True,
                                            msg='FULL VM out of place restore from parent from backup copy')

            self.tc_utils.run_guest_file_restore(self,
                                                 browse_from_snap=True,
                                                 child_level=True,
                                                 msg='Guest Files restores from Child from Snap')

            vm_restore_options = self.tc_utils. \
                run_virtual_machine_restore(self,
                                            browse_from_backup_copy=False,
                                            browse_from_snap=True,
                                            child_level=True,
                                            msg='FULL VM out of Place restores from Child from snap')

            self.tc_utils.run_guest_file_restore(self,
                                                 browse_from_snap=False,
                                                 browse_from_backup_copy=True,
                                                 child_level=True,
                                                 msg='Guest Files restores from Child from Backup Copy')

            vm_restore_options = self.tc_utils. \
                run_virtual_machine_restore(self,
                                            browse_from_snap=False,
                                            browse_from_backup_copy=True,
                                            child_level=True,
                                            msg='FULL VM out of Place restores from Child from snap')

        except Exception:
            pass

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                auto_subclient.post_restore_clean_up(vm_restore_options, True, self.ind_status)
            except Exception:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
            if not self.ind_status:
                self.result_string = self.failure_msg
                self.status = constants.FAILED