# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class definied in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()              --  Initialize TestCase class

    setup()                 --  initial settings for the test case

    run()                   --  run function of this test case
"""

# Test Suite imports
from AutomationUtils.cvtestcase import CVTestCase
from Server.CommcellMigration.ccmhelper import CCMHelper


class TestCase(CVTestCase):
    """Class for executing of Tape Import testcase """

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "SERVER_COMMCELL MIGRATION_TAPE_IMPORT"
        self.tcinputs = {
            "TapeLibrary": None,
            "ClientName": None
        }

    def setup(self):
        """Setup function of this testcase"""

        self.ccm_helper = CCMHelper(self)

    def run(self):
        """Main function for test case execution"""

        try:

            self.ccm_helper.create_entities(tape_library=self.tcinputs["TapeLibrary"])
            sub_client, backupset = self.ccm_helper.get_latest_subclient(self.tcinputs["ClientName"])
            media_list = self.ccm_helper.get_barcode_list(sub_client.subclient_id)
            self.ccm_helper.clean_entities()
            self.ccm_helper.tape_import(media_list)
            sub_client, backupset = self.ccm_helper.get_latest_subclient()
            self.ccm_helper.restore_by_job(backupset, self.ccm_helper.get_jobs_for_subclient(sub_client))

        except Exception as excp:
            self.ccm_helper.server.fail(excp)
