# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import OptionsHelper, VirtualServerUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of Amazon V2 backup and Restore test case with Synthfull backup
    for Tennant Account"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "AMAZON : V2: Synthfull backup (Tennant Account) and Full VM restore"
        self.product = self.products_list.VIRTUALIZATIONAMAZON
        self.feature = self.features_list.DATAPROTECTION
        self.ind_status = True
        self.failure_msg = ""
        self.tcinputs = {}

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = VirtualServerUtils.subclient_initialize(self)

            VirtualServerUtils.decorative_log("Synthfull Backup")
            backup_options = OptionsHelper.BackupOptions(auto_subclient)
            backup_options.backup_type = "SYNTHETIC_FULL"
            auto_subclient.backup(backup_options)

            try:
                VirtualServerUtils.decorative_log("FULL VM out of place restore")
                vm_restore_options = OptionsHelper.FullVMRestoreOptions(auto_subclient, self)
                vm_restore_options.unconditional_overwrite = True
                vm_restore_options.power_on_after_restore = True
                auto_subclient.virtual_machine_restore(vm_restore_options)
            except Exception as exp:
                self.ind_status = False
                self.failure_msg += "\nFailure during/before VM OOP Restore from child: " + str(exp)

            try:
                VirtualServerUtils.decorative_log("Guest Files restores - v2 Indexing")
                file_restore_options = OptionsHelper.FileLevelRestoreOptions(auto_subclient)
                for vm in auto_subclient.vm_list:
                    auto_subclient.guest_file_restore(file_restore_options, discovered_client=vm)
            except Exception as exp:
                self.ind_status = False
                self.failure_msg += "\nFailure during/before Guest File level Restore from child: " + str(exp)

            try:
                VirtualServerUtils.decorative_log("FULL VM out of Place restores - v2 Indexing")
                for vm in auto_subclient.vm_list:
                    auto_subclient.virtual_machine_restore(vm_restore_options, discovered_client=vm)
            except Exception as exp:
                self.ind_status = False
                self.failure_msg += "\nFailure during/before VM OOP Restore from child: " + str(exp)

        except Exception as exp:
            self.log.error('Failed with error: %s ', str(exp))
            self.failure_msg += "Failure Before/During Backup: " + str(exp)
            self.ind_status = False

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                auto_subclient.post_restore_clean_up(vm_restore_options, True, self.ind_status)
            except Exception:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
            if not self.ind_status:
                self.result_string = self.failure_msg
                self.status = constants.FAILED