# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""
from AutomationUtils import config
from AutomationUtils import constants
from AutomationUtils.cvtestcase import CVTestCase
from Install.install_helper import InstallHelper


class TestCase(CVTestCase):
    """Class for verifying the Retire Client Option when no data is associated with the client"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Retire Client - Retire client when no data is associated with it."
        self.config_json = None
        self.commcell = None
        self.windows_machine = None


    def setup(self):
        """Initializes pre-requisites for this test case"""
        self.config_json = config.get_config()
        install_helper = InstallHelper(self.commcell)
        self.windows_machine = install_helper.get_machine_objects(1)[0]

    def run(self):
        """Main function for test case execution"""
        try:
            self.install_helper = InstallHelper(self.commcell, self.windows_machine)
            if not self.commcell.clients.has_client(self.install_helper.client_host):
                self.log.info("Creating {0} client".format(self.windows_machine.os_info))
                job = self.install_helper.install_software()

                if not job.wait_for_completion():
                    raise Exception("{0} Client installation Failed".format(self.windows_machine.os_info))

            self.commcell.clients.refresh()
            self.client = self.commcell.clients.get(self.config_json.Install.windows_client.machine_host)

            # Retire the client
            self.log.info("Will perform Retire operation now on client %s.", self.client.client_name)
            job = self.client.retire()

            # Check the status of the uninstall job triggered to Retire client
            if not job.wait_for_completion():
                raise Exception("Uninstall job failed with error: {0}".format(job.delay_reason))

            # Refreshing the clients associated with the commcell Object
            self.commcell.clients.refresh()

            # Verify that the client has been deleted
            if self.commcell.clients.has_client(self.client.client_name):
                raise Exception("Client Still Exists. Check logs to make sure Retire Operation succeeded.")

            self.log.info("Test case to retire a client when no data is associated with it completed successfully.")

        except Exception as exp:
            self.log.error('Failed with error: %s', exp)
            self.result_string = str(exp)
            self.status = constants.FAILED

        finally:
            self.install_helper.uninstall_client(self.client)
