# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

Basic acceptance test case for Credential Manager in AdminConsole

TestCase:
    __init__()                  --  Initializes the TestCase class

    setup()                     --  All testcase objects are initializes in this method

    run()                       --  Contains the core testcase logic and it is the one executed

"""

from AutomationUtils.cvtestcase import CVTestCase
from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage
from Web.AdminConsole.adminconsole import AdminConsole
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.Helper.roles_helper import RolesMain
from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):

    def __init__(self):
        """Initializes test case class object"""

        super(TestCase, self).__init__()
        self.name = "Basic Acceptance Test Case for Roles in AdminConsole"
        self.product = self.products_list.COMMSERVER
        self.feature = self.features_list.ADMINCONSOLE
        self.utils = TestCaseUtils(self)
        self.tcinputs = {}
        self.browser = None
        self.admin_console = None
        self.roles_helper = None

    def setup(self):

        self.browser = BrowserFactory().create_browser_object(name="User Browser")
        self.browser.open()
        self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
        self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                 self.inputJSONnode['commcell']['commcellPassword'])
        self.roles_helper = RolesMain(AdminPage(self.admin_console.driver))

    def run(self):
        """
        Test Case
        1) Creates Role with given permissions and category names
        2) Modifying the Role name, Overwriting or deleting permissions
        3) Delete Role
        """
        try:

            self.roles_helper.role_name = "test_role"
            self.roles_helper.new_role_name = "new_test_role"

            self.roles_helper.enable_role = True
            self.roles_helper.visible_to_all = False

            self.roles_helper.add_security_roles()

            self.roles_helper.enable_role = not self.roles_helper.enable_role
            self.roles_helper.visible_to_all = not self.roles_helper.visible_to_all
            self.roles_helper.edit_security_role()

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)
            self.log.info(str(exp))

        finally:
            self.roles_helper.delete_security_role()
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
