# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
import time
from AutomationUtils.config import get_config
from AutomationUtils.cvtestcase import CVTestCase
from Reports.Custom.utils import CustomReportUtils
from Web.Common.cvbrowser import BrowserFactory
from Web.Common.cvbrowser import Browser
from Web.Common.exceptions import CVTestCaseInitFailure
from Web.Common.page_object import TestStep
from Web.WebConsole.webconsole import WebConsole
from Web.WebConsole.Reports.navigator import Navigator
from Web.WebConsole.Reports.Metrics.dashboard import Dashboard
from Web.WebConsole.Reports.sla import WebSla
from Reports.utils import TestCaseUtils
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.Reports.report import Report
from Web.AdminConsole.Reports.manage_reports import ManageReport
from Web.WebConsole.Reports.Custom import viewer

_CONFIG = get_config()

class SLAReportDataExpected:
    """SLA report data row column values"""
    client_name = ''
    subclient = ''

    def __init__(self, client_name, subclient):
        self.client_name = client_name
        self.subclient = subclient

class TestCase(CVTestCase):
    """test case class"""
    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Validate SLA counts for Web, Metrics and Custom Report SLA"
        self.browser: Browser = None
        self.webconsole: WebConsole = None
        self.navigator: Navigator = None
        self.dashboard = None
        self.private_metrics = None
        self.utils: TestCaseUtils = None
        self.web_sla = None
        self.metrics_sla = None
        self.admin_console_sla = None
        self.custom_report_utils = CustomReportUtils(self)
        self.report = None
        self.manage_report = None
        self.admin_console = None
        self.SLAReportMissedList = []

    def init_tc(self):
        """initialize test case"""
        try:
            self.utils = TestCaseUtils(self)

            self.init_webconsole()
        except Exception as e:
            raise CVTestCaseInitFailure(e) from e

    def init_webconsole(self):
        """initialize webconsole objects"""
        try:
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.webconsole = WebConsole(self.browser, self.commcell.webconsole_hostname)
            self.webconsole.login(self.inputJSONnode["commcell"]["commcellUsername"],
                                  self.inputJSONnode["commcell"]["commcellPassword"])
            self.navigator = Navigator(self.webconsole)
            self.dashboard = Dashboard(self.webconsole)
        except Exception as e:
            raise CVTestCaseInitFailure(e) from e

    @test_step
    def get_metrics_sla(self):
        """" validate metrics SLA report"""
        self.utils.private_metrics_upload()
        self.navigator.goto_commcell_dashboard(self.commcell.commserv_name)
        self.metrics_sla = int(self.dashboard.get_sla_percent())
        self.log.info("Metrics SLA value {0}".format(self.metrics_sla))

    @test_step
    def get_web_sla(self):
        """ validate webconsole SLA report"""
        self.webconsole.goto_reports()
        self.navigator.goto_commcell_reports('SLA', commcell_name=self.commcell.commserv_name)
        sla = WebSla(self.webconsole)
        self.web_sla = int(sla.get_sla()[0:-1])
        self.log.info("Web SLA value {0}".format(self.web_sla))


    @test_step
    def get_adminconsole_sla(self):
        """ validate adminconsole SLA report"""
        self.custom_report_utils.webconsole = self.webconsole
        self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
        self.admin_console.login(
            self.inputJSONnode["commcell"]["commcellUsername"],
            self.inputJSONnode["commcell"]["commcellPassword"]
        )
        self.navigator = self.admin_console.navigator
        self.manage_report = ManageReport(self.admin_console)
        self.navigator.navigate_to_reports()
        self.manage_report.access_report("SLA")
        self.report = Report(self.admin_console)
        report_viewer = viewer.CustomReportViewer(self.webconsole)
        pie_chart = viewer.PieChart("SLA server summary")
        report_viewer.associate_component(pie_chart)
        details, values = pie_chart.get_chart_legend()
        if values[0].find('Met') >=0 :
           met_sla_clients = int(details[0])
        else:
           met_sla_clients = int(details[1])
        total_clients = int(details[0]) + int(details[1])
        if int(details[0]) > 0:
            self.admin_console_sla = int(100 * (met_sla_clients/total_clients))
        else:
            self.admin_console_sla = int(100)
        self.log.info("Adminconsole SLA value {0}".format(self.admin_console_sla))


    @test_step
    def validate_sla(self):
        """" validate all three SLA values"""
        self.log.info("Web SLA {0}, Metrics SLA {1}, Admin console SLA {2}"
                      .format(self.web_sla, self.metrics_sla, self.admin_console_sla))
        if self.web_sla == self.metrics_sla == self.admin_console_sla:
            self.log.info("Web SLA , Metrics SLA and Custom SLA are matching")
        else:
            raise Exception(
                "Mismatched SLA, All three values are not same. "
                "Web SLA [%s] Metrics SLA [%s], Admin console SLA [%s]" % (
                    self.web_sla,
                    self.metrics_sla,
                    self.admin_console_sla
                )
            )

    def run(self):
        try:
            self.init_tc()
            self.get_web_sla()
            self.get_metrics_sla()
            WebConsole.logout_silently(self.webconsole)
            self.get_adminconsole_sla()
            self.validate_sla()

        except Exception as err:
            self.utils.handle_testcase_exception(err)
        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
