# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

from AutomationUtils.cvtestcase import CVTestCase
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.Helper import domain_helper
from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):

    def __init__(self):
        """Initializes test case class object"""

        super(TestCase, self).__init__()
        self.name = "Basic Acceptance Test Domains in AdminConsole"
        self.product = self.products_list.COMMSERVER
        self.feature = self.features_list.ADMINCONSOLE
        self.browser = None
        self.admin_console = None
        self.domains_obj = None
        self.utils = TestCaseUtils(self)
        self.tcinputs = {
            "netbios_name": None,
            "domain_name": None,
            "domain_username": None,
            "domain_password": None,
            "domain_company": None,
            "proxy_client": None,
            "proxy_client_value": None,
            "user_group": None

        }

    def setup(self):

        self.browser = BrowserFactory().create_browser_object(name="User Browser")
        self.browser.open()

        self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
        self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                 self.inputJSONnode['commcell']['commcellPassword'])

    def run(self):
        try:

            self.domains_obj = domain_helper.DomainHelper(self.admin_console)
            self.domains_obj.domain_name = self.tcinputs['domain_name']
            self.domains_obj.netbios_name = self.tcinputs['netbios_name']
            self.domains_obj.domain_username = self.tcinputs['domain_username']
            self.domains_obj.domain_password = self.tcinputs['domain_password']

            self.domains_obj.proxy_client = self.tcinputs['proxy_client']
            self.domains_obj.proxy_client_value = self.tcinputs['proxy_client_value']
            self.domains_obj.user_group = self.tcinputs['user_group']

            self.log.info("***** Adding a domain*****")
            self.domains_obj.add_domain()
            self.log.info("***** Validating the domain*****")
            self.domains_obj.validate_domain()

            self.log.info("***** Editing a domain*****")
            self.domains_obj.domain_name = self.tcinputs['modified_domain_name']
            self.domains_obj.domain_username = self.tcinputs['modified_domain_username']
            self.domains_obj.domain_password = self.tcinputs['modified_domain_password']
            self.domains_obj.proxy_client = True
            self.domains_obj.edit_domain()
            self.log.info("***** Validating the domain*****")
            self.domains_obj.validate_domain()

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

    def tear_down(self):
        """ To clean-up the test case environment created """
        try:

            self.domains_obj.delete_domain()

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
