# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
This Test Case performs the Sanity Checks for Router Commcell.
"""

from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from Server.routercommcell import RouterCommcell
from Server.Security.userhelper import UserHelper, UserProperties
from AutomationUtils.config import get_config
import datetime

_CONFIG = get_config()

class TestCase(CVTestCase):
    """Class for executing Router Commcell Check test case"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Basic Test Case for Router Commcell"
        self.log = None
        self._user_helper = None
        self.show_to_user = False
        self.tcinputs = {
            "ServiceCommcellName": None,
            "ServiceCommcellAdminUserName": None,
            "ServiceCommcellAdminUserPassword": None
        }
    def setup(self):
        """Setup function of this test case"""
        self.router_commcell = RouterCommcell(self.commcell)

    def run(self):
        """Main function for test case execution"""

        try:
            test_user_name = self.inputJSONnode['commcell']['commcellUsername']
            new_user = 'Test_54128'
            new_user1 = 'Test_541281'
            user_password = _CONFIG.MultiCommcell.Local_users_password
            domain_name = _CONFIG.MultiCommcell.domains.domain2.domain2_name
            domain_smtp = _CONFIG.MultiCommcell.domains.domain2.domain2_smtp
            domain_uname = _CONFIG.MultiCommcell.domains.domain2.domain2_uname
            domain_pwd = _CONFIG.MultiCommcell.domains.domain2.domain2_pwd
            domain_u1 = _CONFIG.MultiCommcell.domains.domain2.domain2_user1
            company_name = 'TC' + str(datetime.datetime.today())
            self.log.info("Step 1: Get Service Commcell Object")
            self.router_commcell.get_service_commcell(self.tcinputs["ServiceCommcellName"],
                                                      self.tcinputs["ServiceCommcellAdminUserName"],
                                                      self.tcinputs["ServiceCommcellAdminUserPassword"])
            self.router_commcell_object = self.router_commcell.service_commcell
            if self.router_commcell_object.domains.has_domain(domain_name):
                self.log.info("Step 2: Deleting the domain as domain exists")
                self.router_commcell_object.domains.delete(domain_name)
            self.log.info("Step 3: Register a Service Commcell for Routing")
            self.router_commcell.register_service_commcell(self.tcinputs["ServiceCommcellName"],
                                                           self.tcinputs["ServiceCommcellAdminUserName"],
                                                           self.tcinputs["ServiceCommcellAdminUserPassword"])
            if self.commcell.domains.has_domain(domain_name):
                self.log.info("Step 2: Deleting the domain as domain exists")
                self.commcell.domains.delete(domain_name)
            self.log.info("Step 4: Check for Registered commcells")
            self.router_commcell.check_registration()
            self.log.info("Step 5: Getting a db connection for service")
            self.router_commcell.create_service_db_connection(self.tcinputs["ServiceCommcellName"])
            self.log.info("Step 6: Validating the redirect rules")
            self.router_commcell.validate_redirect_rules()
            self.log.info("Step 7: Validating the users space")
            self.router_commcell.validate_users_space()
            self.log.info("Step 8: Getting the redirect rules for test user")
            self.router_commcell.get_redirect_service_commcells(test_user_name)
            self.log.info("Step 9: Checking the poll API for user")
            self.router_commcell.check_if_user_exists_on_service(test_user_name)
            self.log.info("Step 10: Creating a user helper object for service commcell")
            self._user_helper = UserHelper(self.router_commcell_object)
            self.log.info("Step 11: Delete user if exists on service")
            self._user_helper.delete_user(new_user, new_user=test_user_name)
            self.log.info("Step 12: Creating a new user on service")
            self._user_helper.create_user(user_name=new_user,
                                          email='a@b.c',
                                          password=user_password)
            self.log.info("Step 13: Getting the redirect list for user")
            self.router_commcell.get_redirect_service_commcells(new_user)
            self.router_commcell.check_if_user_exists_on_service(new_user)
            self._user_helper.delete_user(new_user1, new_user=test_user_name)
            self._user_helper.create_user(user_name=new_user1,
                                          email='test@b.c',
                                          password=user_password)
            self.router_commcell.get_redirect_service_commcells('test@b.c')
            self.log.info("Step 14: Checking POLL API using email")
            self.router_commcell.check_if_mail_exists_on_service('test@b.c')
            self.log.info("Step 15: Creating a new company on Service commcell")
            self.comp_obj = self.router_commcell_object.organizations.add(name=company_name,
                                                                          email='{0}@{1}.com'.format(company_name,
                                                                                                     company_name),
                                                                          contact_name=company_name,
                                                                          company_alias=company_name)
            self.log.info("Step 16: Creating a new user in the company")
            self._user_helper.create_user(user_name='{0}\\newuser'.format(company_name),
                                          email='newuser@{0}.com'.format(company_name),
                                          password=user_password)
            self.log.info("Step 17: Getting the redirect list for user")
            self.router_commcell.get_redirect_service_commcells('{0}\\newuser'.format(company_name))
            self.log.info("Step 18: Adding the domain on service commcell")
            self.router_commcell_object.domains.add(domain_name=domain_smtp,
                                                    netbios_name=domain_name,
                                                    user_name='{0}\\{1}'.format(domain_name, domain_uname),
                                                    password=domain_pwd,
                                                    company_id=0)
            self.log.info("Step 19: Adding the domain user on service commcell")
            if not self.router_commcell_object.users.has_user('{0}\\{1}'.format(domain_name, domain_u1)):
                self._user_helper.create_user(user_name=domain_u1,
                                              email='{0}@{1}'.format(domain_u1, domain_smtp),
                                              domain=domain_name)
            self.router_commcell.get_redirect_service_commcells('{0}\\{1}'.format(domain_name, domain_u1))
            self.log.info("Step 20: unregister the commcell")
            self.router_commcell.unregister_service_commcell()

        except Exception as excp:
            self.log.error('Failed with error: %s', excp)
            self.result_string = excp
            self.status = constants.FAILED
