# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

from AutomationUtils.cvtestcase import CVTestCase
from Reports.storeutils import StoreUtils
from Web.Common.cvbrowser import (
    Browser, BrowserFactory
)
from Web.Common.exceptions import (
    CVTestCaseInitFailure, CVTestStepFailure
)
from Web.Common.page_object import TestStep
from Web.WebConsole.Forms.forms import Forms
from Web.WebConsole.Store.storeapp import StoreApp
from Web.WebConsole.webconsole import WebConsole
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils.config import get_config
from Server.Workflow.workflowhelper import WorkflowHelper

from AutomationUtils.config import get_config

_STORE_CONFIG = get_config()


class TestCase(CVTestCase):

    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Store: Install,Execute Workflow 'SAP Maxdb'"
        self.applicable_os = self.os_list.WINDOWS
        self.product = self.products_list.SOFTWARESTORE
        self.feature = self.features_list.WEBCONSOLE
        self.browser = None
        self.webconsole = None
        self.store = None
        self.storeutils = StoreUtils(self)
        self.workflow = "SAP MaxDB"
        self.workflow_id = "SAP MaxDB"
        self._workflow = None

    def init_tc(self):
        try:
            inputs = self.tcinputs
            self.WorkflowName = inputs['WorkflowName']
            self.clientName = inputs['clientName']
            self.instanceName = inputs['instanceName']
            self.backupType = inputs['backupType']
            self.superDBA_username = inputs['superDBA_username']
            self.superDBA_password = inputs['superDBA_password']
            self.path_to_dbmcli_exe = inputs['path_to_dbmcli_exe']
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.webconsole = WebConsole(
                self.browser,
                self.commcell.webconsole_hostname
            )
            self.webconsole.login(
                self.inputJSONnode['commcell']['commcellUsername'],
                self.inputJSONnode['commcell']['commcellPassword'] )
            self.webconsole.wait_till_load_complete()
            self.store = StoreApp(self.webconsole)
            self.webconsole.goto_store(
                username=_STORE_CONFIG.Cloud.username,
                password=_STORE_CONFIG.Cloud.password
            )

        except Exception as e:
            raise CVTestCaseInitFailure(e) from e

    @test_step
    def start_step1(self):
        """Install status should be shown for workflow
        when it is not installed"""
        pkg_status = self.store.get_package_status(
            self.workflow,
            category="Workflows"
        )
        if pkg_status != "Install":
            raise CVTestStepFailure(
                f"[{self.workflow}] does "
                f"not have [Install] status, found [{pkg_status}]"
            )

    @test_step
    def start_step2(self):
        """After installing workflow, status should be Open"""
        self.store.install_workflow(
            self.workflow, refresh=True
        )

    @test_step
    def start_step3(self):
        """When clicked on Open, workflow form should open """
        self.store.open_package(
            self.workflow,
            category="Workflows"
        )
        forms = Forms(self.webconsole)
        if forms.is_form_open(self.workflow_id) is False:
            raise CVTestStepFailure(
                f"Forms page is not open after clicking Open on "
                f"[{self.workflow}]"
            )
            forms.close_form()

    def run(self):
        try:
            workflow_name = self.workflow
            self._workflow = WorkflowHelper(self, workflow_name, deploy=False)
            self.init_tc()
            self.start_step1()
            self.start_step2()
            self.start_step3()
            self._workflow.execute(
                {
                    'CV_MAXDB_CLIENT_NAME':self.tcinputs['clientName'],
                    'CV_MAXDB_INSTANCE_NAME':self.tcinputs['instanceName'],
                    'CV_BACKUP_TYPE':self.tcinputs['backupType'],
                    'CV_MAXDB_SUPERDBA_USER':self.tcinputs['superDBA_username'],
                    'CV_MAXDB_SUPERDBA_PASSWORD':self.tcinputs['superDBA_password'],
                    'CV_MAXDB_SUPERDBA_PASSWORD_CONFIRM':self.tcinputs['superDBA_password'],
                    'CV_DBMCLI_PATH':self.tcinputs['path_to_dbmcli_exe']
            })

        except Exception as err:
            self.storeutils.handle_testcase_exception(err)
        finally:
            WebConsole.logout_silently(self.webconsole)
            Browser.close_silently(self.browser)
            self._workflow.delete(workflow_name)
