# -*- coding: utf-8 -*-
# pylint: disable=too-many-instance-attributes
# pylint: disable=too-many-locals
# pylint: disable=too-many-statements
# pylint: disable=broad-except

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()             --  Initialize TestCase class

    run()                  --  run function of this test case
"""

from AutomationUtils import constants
from AutomationUtils.cvtestcase import CVTestCase
from FileSystem.FSUtils.fshelper import FSHelper


class TestCase(CVTestCase):
    """Class for executing
        Hadoop Data Protection - Full,Incremental,Differential,Synthfull
        This test case does the following
        Step1,  Create instance for this testcase if it doesn't exist.
        Step2,  Create subclient for this testcase if it doesn't exist.
        Step3,  Add full data for the current run.
        Step4,  Run a full backup for the subclient and verify it completes without failures.
        Step5,  Run a restore of the full backup data and verify correct data is restored.
        Step6,  Run a find operation for the full job and verify the returned results.
        Step7,  Add new data for the incremental
        Step8,  Run an incremental backup for the subclient and verify it completes without failures.
        Step9,  Run a restore of the incremental backup data and verify correct data is restored.
        Step10, Run a find operation for the incremental job and verify the returned results.
        Step11, Perform all modifications on the existing data.
        Step12, Run an incremental backup for the subclient and verify it completes without failures.
        Step13, Run a restore of the incremental backup data and verify correct data is restored.
        Step14, Run a find operation for the incremental job and verify the returned results.
        Step15, Add new data for the differential
        Step16, Run a differential backup for the subclient and verify it completes without failures.
        Step17, Run a restore of the differential backup data and verify correct data is restored.
        Step18, Run a find operation for the differential job and verify the returned results.
        Step19, Add new data for the incremental
        Step20, Run a synthfull job
        Step21, Run an incremental backup after synthfull for the subclient and verify it completes without failures.
        Step22, Run a restore of the incremental backup data and verify correct data is restored.
        Step23, Run a find operation for the incremental job and verify the returned results.
        Step24, Perform all modifications on the existing data.
        Step25, Run a synthfull job
        Step26, Run an incremental backup after synthfull for the subclient and verify it completes without failures.
        Step27, Run a restore of the incremental backup data and verify correct data is restored.
        Step28, Run a find operation for the incremental job and verify the returned results.
        Step29, Run a restore of the complete subclient data and verify correct data is restored.
        Step30, Run a find operation for the entire subclient and verify the returned results.
        """

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Hadoop Data Protection - Full,Incremental,Differential,Synthfull"
        self.applicable_os = self.os_list.UNIX
        self.product = self.products_list.FILESYSTEM
        self.feature = self.features_list.DATAPROTECTION
        self.show_to_user = True
        self.tcinputs = {"TestPath": None}
        # Other attributes which will be initialized in
        # FSHelper.populate_tc_inputs
        self.test_path = None
        self.slash_format = ''
        self.helper = None
        self.storage_policy = None
        self.client_machine = None
        self.acls = None
        self.unicode = None
        self.xattr = None
        self.long_path = None
        self.should_wait = None
        self.is_client_big_data_apps = None
        self.master_node = None
        self.data_access_nodes = None
        self.no_of_streams = None
        self.instance_name = None
        self.backupset_name = None
        self.runid = 0
        self.cleanup_run = None

    def run(self):
        """Main function for test case execution"""
        log = self.log
        try:
            # Initialize test case inputs
            FSHelper.populate_tc_inputs(self, mandatory=False)
            self.should_wait = False

            test_path = self.test_path
            slash_format = self.slash_format
            helper = self.helper
            machine = self.client_machine
            if test_path.endswith(slash_format):
                test_path = str(test_path).rstrip(slash_format)
            storage_policy = self.storage_policy
            restore_nodes = self.data_access_nodes

            log.info("""Hadoop Data Protection - Full,Incremental,Differential,Synthfull
                        This test case does the following
                        Step1,  Create instance for this testcase if it doesn't exist.
                        Step2,  Create subclient for this testcase if it doesn't exist.
                        Step3,  Add full data for the current run.
                        Step4,  Run a full backup for the subclient and verify it completes without failures.
                        Step5,  Run a restore of the full backup data and verify correct data is restored.
                        Step6,  Run a find operation for the full job and verify the returned results.
                        Step7,  Add new data for the incremental
                        Step8,  Run an incremental backup for the subclient and verify it completes without failures.
                        Step9,  Run a restore of the incremental backup data and verify correct data is restored.
                        Step10, Run a find operation for the incremental job and verify the returned results.
                        Step11, Perform all modifications on the existing data.
                        Step12, Run an incremental backup for the subclient and verify it completes without failures.
                        Step13, Run a restore of the incremental backup data and verify correct data is restored.
                        Step14, Run a find operation for the incremental job and verify the returned results.
                        Step15, Add new data for the differential
                        Step16, Run a differential backup for the subclient and verify it completes without failures.
                        Step17, Run a restore of the differential backup data and verify correct data is restored.
                        Step18, Run a find operation for the differential job and verify the returned results.
                        Step19, Add new data for the incremental
                        Step20, Run a synthfull job
                        Step21, Run an incremental backup after synthfull for the subclient and verify it completes without failures.
                        Step22, Run a restore of the incremental backup data and verify correct data is restored.
                        Step23, Run a find operation for the incremental job and verify the returned results.
                        Step24, Perform all modifications on the existing data.
                        Step25, Run a synthfull job
                        Step26, Run an incremental backup after synthfull for the subclient and verify it completes without failures.
                        Step27, Run a restore of the incremental backup data and verify correct data is restored.
                        Step28, Run a find operation for the incremental job and verify the returned results.
                        Step29, Run a restore of the complete subclient data and verify correct data is restored.
                        Step30, Run a find operation for the entire subclient and verify the returned results.
                        """)

            log.info("Step1, Create Instance for this testcase if it doesn't exist")
            instance_name = "Instance_{0}".format(self.id)
            helper.create_instance(instance_name, delete=self.cleanup_run)
            self.instance_name = instance_name

            log.info("Step2,  Create subclient for this testcase if it doesn't exist.")
            subclient_name = "subclient_{0}".format(self.id)
            subclient_content = []
            subclient_content.append("{0}{1}{2}".format(test_path, slash_format, subclient_name))
            tmp_path = "".join(
                [test_path, slash_format, 'cvauto_tmp', slash_format, subclient_name, slash_format, str(self.runid)])
            run_path = "".join([subclient_content[0], slash_format, str(self.runid)])
            full_data_path = "{0}{1}full".format(run_path, slash_format)
            helper.create_subclient(
                name=subclient_name,
                storage_policy=storage_policy,
                content=subclient_content,
                data_readers=self.no_of_streams,
                allow_multiple_readers=self.no_of_streams > 1,
                data_access_nodes=self.data_access_nodes,
                delete=self.cleanup_run
                )

            log.info("Step3,  Add full data for the current run.")
            machine.generate_test_data(
                full_data_path,
                acls=self.acls,
                unicode=self.unicode,
                xattr=self.xattr,
                long_path=self.long_path
                )

            log.info("Step4,  Run a full backup for the subclient and verify it completes without failures.")
            job_full = helper.run_backup_verify(backup_level="Full")[0]

            log.info("Step5,  Run a restore of the full backup data and verify correct data is restored.")
            helper.run_restore_verify(
                slash_format,
                full_data_path,
                tmp_path, "full", job_full,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step6,  Run a find operation for the full job and verify the returned results.")
            helper.run_find_verify(subclient_content[0])

            log.info("Step7,  Add new data for the incremental")
            incr_diff_data_path = "".join([run_path, slash_format, "incr_diff"])
            helper.add_new_data_incr(incr_diff_data_path, slash_format, dirs=1, files=1, file_size=20)

            log.info("Step8,  Run an incremental backup for the subclient and verify it completes without failures.")
            job_incr1 = helper.run_backup_verify(backup_level="Incremental")[0]

            log.info("Step9,  Run a restore of the incremental backup data and verify correct data is restored.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path,
                tmp_path, "incr_diff", job_incr1,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step10, Run a find operation for the incremental job and verify the returned results.")
            helper.run_find_verify(incr_diff_data_path, job_incr1)

            log.info("Step11, Perform all modifications on the existing data.")
            helper.mod_data_incr()

            log.info("Step12, Run an incremental backup for the subclient and verify it completes without failures.")
            job_incr2 = helper.run_backup_verify(backup_level="Incremental")[0]

            log.info("Step13, Run a restore of the incremental backup data and verify correct data is restored.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path,
                tmp_path,
                "incr_diff",
                job_incr2,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)
            log.info("Verifying latest browse/restore for the incremental.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path,
                tmp_path,
                "incr_diff",
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step14, Run a find operation for the incremental job and verify the returned results.")
            helper.run_find_verify(incr_diff_data_path, job_incr2)

            log.info("Step15, Add new data for the differential")
            incr_new_diff_path = "".join([incr_diff_data_path, slash_format, "differential"])
            machine.generate_test_data(
                incr_new_diff_path,
                acls=self.acls,
                unicode=self.unicode,
                xattr=self.xattr,
                long_path=self.long_path,
            )

            log.info("Step16, Run a differential backup for the subclient and verify it completes without failures.")
            job_diff = helper.run_backup_verify(backup_level="Differential")[0]

            log.info("Step17, Run a restore of the differential backup data and verify correct data is restored.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path, tmp_path,
                "incr_diff", job_diff,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step18, Run a find operation for the differential job and verify the returned results.")
            helper.run_find_verify(incr_diff_data_path, job_diff)

            log.info("Step19, Add new data for the incremental")
            incr_diff_data_path = "".join([run_path, slash_format, "incr_diff_synth"])
            helper.add_new_data_incr(incr_diff_data_path, slash_format, dirs=1, files=1, file_size=20)

            log.info("Step20, Run a synthfull job")
            helper.run_backup_verify(backup_level="Synthetic_full")

            log.info("Step21, Run an incremental backup after synthfull for the subclient"
                     " and verify it completes without failures.")
            job_incr1 = helper.run_backup_verify(backup_level="Incremental")[0]

            log.info("Step22, Run a restore of the incremental backup data and verify correct data is restored.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path, tmp_path,
                "incr_diff_synth", job_incr1,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step23, Run a find operation for the incremental job and verify the returned results.")
            helper.run_find_verify(incr_diff_data_path, job_incr1)

            log.info("Step24, Perform all modifications on the existing data.")
            helper.mod_data_incr()

            log.info("Step25, Run a synthfull job")
            helper.run_backup_verify(backup_level="Synthetic_full")

            log.info("Step26, Run an incremental backup after synthfull for the subclient"
                     " and verify it completes without failures.")
            job_incr2 = helper.run_backup_verify(backup_level="Incremental")[0]

            log.info("Step27, Run a restore of the incremental backup data and verify correct data is restored.")
            log.info("Verifying time based browse/restore for the incremental.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path,
                tmp_path,
                "incr_diff_synth",
                job_incr2,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)
            log.info("Verifying latest browse/restore for the incremental.")
            helper.run_restore_verify(
                slash_format,
                incr_diff_data_path,
                tmp_path,
                "incr_diff_synth",
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step28, Run a find operation for the incremental job and verify the returned results.")
            helper.run_find_verify(incr_diff_data_path, job_incr2)

            log.info("Step29, Run a restore of the complete subclient data and verify correct data is restored.")
            helper.run_restore_verify(
                slash_format,
                subclient_content[0],
                tmp_path,
                subclient_name,
                cleanup=True,
                is_client_big_data_apps=self.is_client_big_data_apps,
                destination_instance=self.instance_name,
                no_of_streams=self.no_of_streams,
                restore_nodes=restore_nodes)

            log.info("Step30, Run a find operation for the entire subclient and verify the returned results.")
            helper.run_find_verify(subclient_content[0])

            if self.cleanup_run:
                machine.remove_directory(subclient_content[0])
            machine.remove_directory(tmp_path)
            # delete backupset/instance if clean up is specified
            if self.cleanup_run:
                if self.is_client_big_data_apps:
                    self.agent.instances.delete(self.instance_name)
                else:
                    self.instance.backupsets.delete(self.backupset_name)
            log.info("***TEST CASE COMPLETED SUCCESSFULLY AND PASSED***")

        except Exception as excp:
            log.error('Failed with error: %s', str(excp))
            self.result_string = str(excp)
            self.status = constants.FAILED
