# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

 TestCase is the only class defined in this file.

 TestCase: Class for executing this test case

 TestCase:
     __init__()      --  initialize TestCase class

     run()           --  run function of this test case

     filters_validate -- Function to validate the filters
 """
import time
from datetime import datetime
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from AutomationUtils.machine import Machine
from FileSystem.FSUtils.fshelper import FSHelper


class TestCase(CVTestCase):
    """TestCase for Basic acceptance Test of Client Group filters"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Client Group Filters test"
        self.tcinputs = {
            "StoragePolicyName": None,
            "ServerGroupName": None,
            "WindowsClient": None,
            "UnixClient": None
        }
        self.client_group_obj = None

    def filters_validate(self, client):
        """Function to validate whether the filters were set correctly or not

        Args:
            client        (obj)  --  Client object.

        """

        self.client = client
        self.agent = self.client.agents.get('File System')
        self.instance = self.agent.instances.get('DefaultInstanceName')
        self.machine = Machine(machine_name=self.client)
        self.helper = FSHelper(self)
        self.helper.populate_tc_inputs(self, mandatory=False)
        self.log.info("Creating test data")

        if self.machine.os_info == "WINDOWS":
            filter_extensions = str(self.windows_filters) + ",*.bcd"

        elif self.machine.os_info == "UNIX":
            filter_extensions = str(self.unix_filters) + ",*.tar"

        filter_extension = filter_extensions.replace('*', '')
        self.helper.generate_testdata(filter_extension.split(','))
        install_dir = self.client.install_directory
        content_path = self.machine.join_path(install_dir, "Test")
        sub_content = content_path.split('*')
        backupset_name = "Test_53908"

        self.helper.create_backupset(backupset_name, delete=True)
        self.helper.create_subclient("Filter", self.tcinputs['StoragePolicyName'], sub_content)

        win_filters1 = str(self.windows_filters).split(',')
        unix_filters1 = str(self.unix_filters).split(',')
        time.sleep(60)
        self.helper.run_backup("FULL")
        self.helper.validate_filters(win_filters1, unix_filters1)

    def run(self):
        """Creates a group with the specified clients and sets the filters"""

        try:

            if self.commcell.client_groups.has_clientgroup(self.tcinputs['ServerGroupName']):
                self.log.info("Client group already exists, deleting it.")
                self.commcell.client_groups.delete(self.tcinputs['ServerGroupName'])

            clients = self.tcinputs['WindowsClient'] + ',' + self.tcinputs['UnixClient']

            self.client_group_obj = self.commcell.client_groups.add(self.tcinputs['ServerGroupName'], clients)
            self.log.info("Created client group : %s", self.tcinputs['ServerGroupName'])
            self.unix_client = self.commcell.clients.get(self.tcinputs['UnixClient'])
            self.windows_client = self.commcell.clients.get(self.tcinputs['WindowsClient'])

            if not self.unix_client.is_ready:
                self.log.error("Check readiness for the unix client failed")

            if not self.windows_client.is_ready:
                self.log.error("Check readiness for the windows client failed")

            self.windows_filters = "*.doc,*.txt"
            self.unix_filters = "*.dmg,*.pkg"

            cg_filters = {"windows_filters": str(self.windows_filters).split(','),
                          "unix_filters": str(self.unix_filters).split(',')
                          }
            self.client_group_obj.client_group_filter = cg_filters
            self.log.info("The  filters have been set")

            self.filters_validate(self.windows_client)
            self.filters_validate(self.unix_client)

        except Exception as excp:
            self.log.info(str(excp))
            self.log.error("TEST CASE FAILED")
            self.status = constants.FAILED
            self.result_string = str(excp)
