# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
""" Metrics Report : Verify Health Tiles loaded properly"""
from Web.Common.cvbrowser import (
    BrowserFactory,
    Browser
)
from Web.Common.exceptions import (
    CVTestCaseInitFailure,
    CVTestStepFailure,
    CVWebAutomationException
)
from Web.Common.page_object import TestStep
from Web.WebConsole.Reports.Metrics.health import Health
from Web.WebConsole.Reports.Metrics.health_tiles import GenericTile

from Web.WebConsole.webconsole import WebConsole
from Web.WebConsole.Reports.navigator import Navigator

from AutomationUtils.cvtestcase import CVTestCase

from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):
    """TestCase class used to execute the test case from here."""

    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Metrics Report : Verify Health Tiles loaded properly"
        self.browser = None
        self.webconsole = None
        self.utils = TestCaseUtils(self)

    def _init_tc(self):
        """Initial configuration for the test case"""
        try:
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.webconsole = WebConsole(self.browser, self.commcell.webconsole_hostname)
            self.webconsole.login()
            self.webconsole.goto_commcell_dashboard()
            navigator = Navigator(self.webconsole)
            navigator.goto_commcell_reports("Health", self.commcell.commserv_name)
        except Exception as exception:
            raise CVTestCaseInitFailure(exception) from exception

    @test_step
    def verify_tiles(self):
        """Verify for properly loaded tiles"""
        health = Health(self.webconsole)
        outcome = list()
        status = list()
        for tile_name in health.get_visible_tiles():
            tile = GenericTile(self.webconsole, tile_name)
            if not tile.get_outcome():
                outcome.append(tile.tile_name())
            try:
                tile.get_health_status()
            except CVWebAutomationException:
                status.append(tile.tile_name())

        if status or outcome:
            raise CVTestStepFailure(f"{status} does not have any status \n "
                                    f"{outcome} does not have any content in the body")

    def run(self):
        try:
            self._init_tc()
            self.verify_tiles()
        except Exception as err:
            self.utils.handle_testcase_exception(err)
        finally:
            WebConsole.logout_silently(self.webconsole)
            Browser.close_silently(self.browser)
