# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
Test case to check the basic acceptance of user groups in Admin console.

functions over,
1. Creation of user group based on criteria passed as
   arguments to the test case and base files.
2. Validates if the user group is created successfully and the values are
   retained correctly.
3. Edits the user group details for created  group and also adds users to it and
    re-validates against the user inputs.
4. Removes the users associated in step 4.
5. Deletes the user group created.

TestCase:
    __init__()      --  Method to initialize TestCase class

    run()           --  Method to run the functionality of this test case

    tear_down()     --  Method to do cleanup and close open processes
"""

from AutomationUtils.cvtestcase import CVTestCase

from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.Helper.UserGroupHelper import UserGroupMain

from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):

    """ Basic Acceptance test for User Groups"""

    def __init__(self):
        """
       Initializing the Test case file
        """
        super(TestCase, self).__init__()
        self.name = "Basic Acceptance Test User Groups in AdminConsole"
        self.product = self.products_list.COMMSERVER
        self.feature = self.features_list.ADMINCONSOLE
        self.show_to_user = False
        self.utils = TestCaseUtils(self)
        self.browser = None
        self.admin_console = None
        self.user_group_obj = None
        self.tcinputs = {'plan': None,
                         'users': None}

    def run(self):

        try:
            self.log.info("Started executing %s test case", self.id)
            self.log.info("*" * 10 + " Initialize browser objects " + "*" * 10)

            factory = BrowserFactory()
            self.browser = factory.create_browser_object()
            self.browser.open()

            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                     self.inputJSONnode['commcell']['commcellPassword'])
            self.user_group_obj = UserGroupMain(self.admin_console)

            self.user_group_obj.add_new_user_group()
            self.log.info("User group creation completed. validating User group...")

            self.user_group_obj.validate_user_group()
            self.log.info("Initial User group validation completed. Editing Details")

            self.user_group_obj.group_name = 'Group2_53712'
            self.user_group_obj.description = 'Group2_53712'
            self.user_group_obj.quota = False
            self.user_group_obj.group_enabled = False
            self.user_group_obj.laptop_admins = True
            self.user_group_obj.plan = self.tcinputs['plan']
            self.user_group_obj.user_list = self.tcinputs['users'].split(',')

            self.user_group_obj.edit_user_group_details()
            self.log.info("User group editing completed. validating User group...")

            self.user_group_obj.validate_user_group()
            self.log.info("Post Editing validation completed. Removing associated users"
                          "from user group")

            self.user_group_obj.remove_users_from_user_group()
            self.log.info("Users are removed successfully. Cleaning up the entities created")

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

    def tear_down(self):
        """ To clean-up the test case environment created """
        try:

            self.user_group_obj.delete_user_group()

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
