# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
Test case to check the basic acceptance of users in Admin console.

functions over,
1. Creation of users based on different criteria's passed as
   arguments to the test case and base files.
2. Validates if the users are created successfully and the values are
   retained correctly.
3. Deletes the users created & verified in above steps.
"""

from AutomationUtils.cvtestcase import CVTestCase

from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.Helper.UserHelper import UserMain

from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):
    """ Basic Acceptance test for Users """

    def __init__(self):
        """
         Initializing the Test case file
        """
        super(TestCase, self).__init__()
        self.name = "Basic Acceptance Test Users in AdminConsole"
        self.product = self.products_list.COMMSERVER
        self.feature = self.features_list.ADMINCONSOLE
        self.show_to_user = False
        self.browser = None
        self.admin_console = None
        self.user_obj = None
        self.utils = TestCaseUtils(self)

        self.tcinputs = {
            'user_groups': None,
            'plan': None,
            'admin_password': None,
            'external_provider': None,
            'external_user_name': None,
            'external_email': None
            }

    def run(self):

        try:
            self.log.info("Started executing %s testcase", self.id)
            self.log.info("*" * 10 + " Initialize browser objects " + "*" * 10)

            factory = BrowserFactory()
            self.browser = factory.create_browser_object()
            self.browser.open()

            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                     self.inputJSONnode['commcell']['commcellPassword'])
            self.user_obj = UserMain(self.admin_console, self.commcell)

            self.user_obj.add_new_local_user()
            self.log.info("User Creation completed. validating User...")

            self.user_obj.validate_user()
            self.log.info("Initial User validation completed")

            self.user_obj.new_user_name = 'Updated_53652'
            self.user_obj.email = 'abc@commvault.com'
            self.user_obj.user_groups = self.tcinputs['user_groups'].split(',')
            self.user_obj.full_name = 'Updated_53652'
            self.user_obj.password = '######'
            self.user_obj.user_enabled = False
            self.user_obj.plan = self.tcinputs['plan']
            self.user_obj.admin_password = self.tcinputs['admin_password']

            self.log.info("Now proceeding to edit user details")
            self.user_obj.edit_local_user_details()
            self.log.info("User editing completed")

            self.user_obj.validate_user()
            self.log.info("User validation after editing completed."
                          " Adding new user with system password enabled")

            self.user_obj.user_name = 'User2_53652'
            self.user_obj.email = 'def@commvault.com'
            self.user_obj.user_groups = self.tcinputs['user_groups'].split(',')
            self.user_obj.full_name = 'User2_53652'
            self.user_obj.system_password = True
            self.user_obj.invite_user = True

            self.user_obj.add_new_local_user()
            self.log.info("Local User with system password created successfully."
                          " Adding an external User")

            self.user_obj.external_provider = self.tcinputs['external_provider']
            self.user_obj.user_name = self.tcinputs['external_user_name']
            self.user_obj.email = self.tcinputs['external_email']
            self.user_obj.user_groups = self.tcinputs['user_groups'].split(',')
            self.user_obj.invite_user = True

            self.user_obj.add_new_external_user()
            self.log.info("External User created successfully.")
            self.log.info("User creation, editing and validation succeeded. Deleting created users.")

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

    def tear_down(self):
        """ To clean-up the test case environment created """
        try:

            self.user_obj.delete_user()

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
