# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# See LICENSE.txt in the project root for
# license information
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from Web.Common.cvbrowser import BrowserFactory
from Web.AdminConsole.Helper.LoginHelper import LoginMain
from Web.AdminConsole.Helper.VirtualServerHelper import AdminConsoleVirtualServer

class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of AzureRM incremental backup and Restore
     in AdminConsole"""""

    def __init__(self):
        """" Initializes test case class objects"""""
        super(TestCase, self).__init__()
        self.name = "Basic Acceptance Test of Azure RM incremental Backup and Restore in AdminConsole"
        self.product = self.products_list.VIRTUALIZATIONAZURE
        self.feature = self.features_list.ADMINCONSOLE
        self.show_to_user = False
        self.test_individual_status = True
        self.test_individual_failure_message = ""

    def run(self):
        """"Main function for testcase execution"""
        try:
            self.log.info("Started executing %s testcase", self.id)

            self.log.info("%(boundary)s %(message)s %(boundary)s",
                          {'boundary': "-" * 25, 'message': "Initialize browser objects"})

            factory = BrowserFactory()
            browser = factory.create_browser_object()
            browser.open(maximize=True)
            driver = browser.driver
            self.log.info("Creating the login object")
            login_obj = LoginMain(driver, self.csdb)

            login_obj.login(self.inputJSONnode['commcell']['commcellUsername'],
                            self.inputJSONnode['commcell']['commcellPassword']
                            )

            self.log.info("Login completed successfully")
            vsa_obj = AdminConsoleVirtualServer(self.instance, driver,
                                                self.commcell, self.csdb)

            vsa_obj.hypervisor = self.tcinputs['ClientName']
            vsa_obj.instance = self.tcinputs['InstanceName']
            vsa_obj.subclient = self.tcinputs['SubclientName']
            vsa_obj.restore_proxy = self.tcinputs.get('RestoreProxy', None)
            vsa_obj.storage_account = self.tcinputs.get('StorageAccount', None)
            vsa_obj.resource_group = self.tcinputs.get('ResourceGroup', None)

            self.log.info("Created VSA object successfully.")

            self.log.info(
                "----------------------------------------Backup--------------------"
            )
            vsa_obj.backup_type = "INCR"
            vsa_obj.backup()

            self.log.info(
                "-----------------------Attach Disk--------------"
            )

            try:
                # Attach Disk Restore
                vsa_obj.attach_disk_restore()
            except Exception as exp:
                self.test_individual_status = False
                self.test_individual_failure_message = str(exp)

            self.log.info(
                "---------------------------------File Level restore--------------"
            )

            try:
                #File level Restore
                vsa_obj.file_level_restore()
            except Exception as exp:
                self.test_individual_status = False
                self.test_individual_failure_message = str(exp)

            self.log.info(
                "---------------out of Place Full VM Restore-----------------"
            )

            try:
                # Full VM out of Place restore
                vsa_obj.full_vm_in_place = False
                vsa_obj.full_vm_restore()
            except Exception as exp:
                self.test_individual_status = False
                self.test_individual_failure_message = str(exp)

            self.log.info(
                "--------------- In Place Full VM Restore--------------------"
            )

            try:
                # Full VM In Place restore
                vsa_obj.full_vm_in_place = True
                vsa_obj.full_vm_restore()
            except Exception as exp:
                self.test_individual_status = False
                self.test_individual_failure_message = str(exp)

        except Exception as exp:

            self.log.error('Failed with error: %s', str(exp))
            self.result_string = str(exp)
            self.status = constants.FAILED

        finally:
            browser.close()
            if vsa_obj:
                vsa_obj.cleanup_testdata()
