# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import OptionsHelper, VirtualServerUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of VMware template backup and Restore test case"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "VSA VMWARE Template Full Backup and Restore"
        self.product = self.products_list.VIRTUALIZATIONVMWARE
        self.feature = self.features_list.DATAPROTECTION
        self.status_ind = True
        self.failure_message = ""
        self.show_to_user = True

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = VirtualServerUtils.subclient_initialize(self)
            VirtualServerUtils.decorative_log("Backup")
            backup_options = OptionsHelper.BackupOptions(auto_subclient)
            auto_subclient.backup(backup_options, template=True)

            try:
                VirtualServerUtils.decorative_log("Template Out of place restore")
                vm_restore_options = OptionsHelper.FullVMRestoreOptions(auto_subclient, self)
                vm_restore_options.unconditional_overwrite = True
                vm_restore_options.validation = False
                vm_restore_options.power_on_after_restore = False
                auto_subclient.virtual_machine_restore(vm_restore_options)
                auto_subclient.vm_restore_validator(vm_restore_options)
            except Exception as exp:
                self.status_ind = False
                self.failure_message += str(exp)

        except Exception as exp:
            self.log.error('Failed with error: {} '.format(exp))
            self.result_string = str(exp)
            self.status = constants.FAILED

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                for vm in auto_subclient.vm_list:
                    auto_subclient.hvobj.VMs[vm].convert_vm_to_template()
                auto_subclient.post_restore_clean_up(vm_restore_options)
            except NameError:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
                pass
            if not self.status_ind:
                self.result_string = self.failure_message
                self.status = constants.FAILED
