# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import VsaTestCaseUtils, VirtualServerUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of VSA backup and Restore test case"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = 'VSA VMWARE Full Backup and Ful vm restore with all disk provision option'
        self.tc_utils = VsaTestCaseUtils.VSATestCaseUtils(self,
                                                          self.products_list.VIRTUALIZATIONVMWARE,
                                                          self.features_list.DATAPROTECTION)

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = VirtualServerUtils.subclient_initialize(self)
            self.tc_utils.assign_sub_client(auto_subclient)
            backup_options = self.tc_utils.run_backup(self, msg='Streaming Backup')

            VirtualServerUtils.decorative_log("Validating if all types of disk are in the vms")
            disk_type_list = {'Thin', 'Thick Lazy Zero', 'Thick Eager Zero'}
            for vm in auto_subclient.vm_list:
                _disks_type_vm = set(auto_subclient.hvobj.VMs[vm].get_disk_provision.values())
                if disk_type_list.issubset(_disks_type_vm):
                    self.log.info("All 3 type of disks present in the vm {}".format(vm))
                else:
                    raise Exception("All Disks type not present in VM {}".format(vm))
            disk_type_list.add('Original')

            for disk_opt in disk_type_list:
                msg = 'FULL VM out of Place restore with disk option: {}'.format(disk_opt)
                vm_restore_options = self.tc_utils. \
                    run_virtual_machine_restore(self,
                                                power_on_after_restore=True,
                                                unconditional_overwrite=True,
                                                disk_option=disk_opt,
                                                msg=msg)

        except Exception:
            pass

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                auto_subclient.post_restore_clean_up(vm_restore_options)
            except Exception:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
            if not self.ind_status:
                self.result_string = self.failure_msg
                self.status = constants.FAILED
