# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import VsaTestCaseUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of Vmware Full Snap backup and Restore test case
    without metadata collection"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = 'VSA VMWARE Incremetnal Backup and Restore Cases'
        self.tc_utils = VsaTestCaseUtils.VSATestCaseUtils(self,
                                                          self.products_list.VIRTUALIZATIONVMWARE,
                                                          self.features_list.DATAPROTECTION)
        self.ind_status = True
        self.failure_msg = ''

    def run(self):
        """Main function for test case execution"""

        try:

            auto_subclient = self.tc_utils.initialize(self)
            backup_options = self.tc_utils.run_backup(self,
                                                      advance_options={
                                                          'create_backup_copy_immediately': True},
                                                      msg='Incremental Snap Backup and Backup copy',
                                                      backup_type='INCREMENTAL',
                                                      backup_method='SNAP')
            self.tc_utils.run_guest_file_restore(self,
                                                 browse_from_snap=True)
            self.tc_utils.run_disk_restore(self,
                                           browse_from_snap=True)
            vm_restore_options = self.tc_utils.run_virtual_machine_restore(self,
                                                                           power_on_after_restore=True,
                                                                           unconditional_overwrite=True,
                                                                           browse_from_snap=True
                                                                           )
            vm_restore_options = self.tc_utils.run_virtual_machine_restore(self,
                                                                           in_place_overwrite=True)
            self.tc_utils.run_guest_file_restore(self,
                                                 browse_from_snap=False,
                                                 browse_from_backup_copy=True)
            self.tc_utils.run_disk_restore(self,
                                           browse_from_backup_copy=True)
            vm_restore_options = self.tc_utils.run_virtual_machine_restore(self,
                                                                           in_place_overwrite=False,
                                                                           unconditional_overwrite=True,
                                                                           browse_from_backup_copy=True
                                                                           )
            vm_restore_options = self.tc_utils.run_virtual_machine_restore(self,
                                                                           in_place_overwrite=True)

        except Exception:
            pass

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                auto_subclient.post_restore_clean_up(vm_restore_options)
            except Exception:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
                pass
            if not self.ind_status:
                self.result_string = self.failure_msg
                self.status = constants.FAILED