"""
TestCase to validate Metrics collection query upgrade script
"""

from AutomationUtils.cvtestcase import CVTestCase
from Reports.metricsutils import MetricsServer

from Web.Common.page_object import TestStep
from Web.Common.exceptions import CVTestStepFailure

import datetime


class TestCase(CVTestCase):
    """TestCase to validate Metrics collection query upgrade script"""

    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Metrics: verify metrics upgrade script"
        self.metrics_server = None

    def int_tc(self):
        self.metrics_server = MetricsServer(
            self.commcell.webconsole_hostname,
            self.inputJSONnode['commcell']["commcellUsername"],
            self.inputJSONnode['commcell']["commcellPassword"]
        )

    def get_recut_install_date(self):
        query = """select max(OpTimeUTC) from simXMLrequest 
        where clientid=2 and  
        xmlblob.value('(/CVInstallManager_ClientsComposition/@clientOperationtype)[1]','int')=0"""
        install_date = self.metrics_server.metrics_server_api.execute_sql(
            query,
            desc='Getting recut installed date'
        )
        return datetime.datetime.strptime(install_date[0][0], "%b %d, %Y, %H:%M:%S %p")

    def get_metrics_upgrade_date(self):
        mc = self.metrics_server.metrics_machine
        file = mc.read_file(self.metrics_server.log_dir + '/MetricsUpgrade.log')
        last_line = file.split('\n')[-17]
        last_line = last_line.strip()
        self.log.info(f'last line from MetricsUpgrade.log:[{last_line}]')
        method = last_line.split(' ')[1]
        if 'CommservSurveyUpgrade.cmd' not in method:
            raise CVTestStepFailure('CommservSurveyUpgrade.cmd not found in MetricsUpgrade.log')
        date = last_line.split(' ')[2]
        log_time = datetime.datetime.strptime(date, "%d-%m-%Y")
        current_year = datetime.datetime.now().year
        return log_time.replace(year=current_year)

    def get_enabled_offline_scripts(self):
        query = """
        SELECT CollectScriptName FROM cf_CommservSurveyQueries WITH (NOLOCK) 
        WHERE flags & 2 = 2 AND QueryId >= 10000"""
        result = self.metrics_server.metrics_server_api.execute_sql(
            query,
            database_name='CVCloud',
            desc='Getting enabled offline queries'
        )
        query_list = []
        for query in result:
            query_list.append(query[0])
        return query_list

    @test_step
    def verify_last_run_date(self):
        """Verifies upgrade script after last recut install"""
        metrics_date = self.get_metrics_upgrade_date()
        recut_date = self.get_recut_install_date()
        date_diff = (recut_date - metrics_date).days
        if date_diff > 2:
            raise CVTestStepFailure(
                "Metrics upgrade script didnt run along with last recut installation, Last install"
                f" date [{recut_date}] and last metrics upgrade script run date [{metrics_date}]"
            )

    @test_step
    def verify_offline_query_exist(self, offline_scripts):
        """Verifies offline queries exist"""
        for script in offline_scripts:
            if not self.metrics_server.is_offline_query_exist(script):
                raise CVTestStepFailure(f'Offline query [{script}] not found in script directory')

    def run(self):
        self.int_tc()
        self.verify_last_run_date()
        offline_scripts = self.get_enabled_offline_scripts()
        self.verify_offline_query_exist(offline_scripts)
