# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
Test case to check the basic acceptance of operation window in Admin console.

It verifies
1. Creation of operation rule based on different criteria's passed as arguments
2. Validates if the operation rule is created successfully.
3. Editing of operation rule created in above steps.
4. Deletion of operation rule created, edited & verified in above steps.
"""

import ast
from AutomationUtils.cvtestcase import CVTestCase

from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.Helper.OperationWindowHelper import OperationWindowMain

from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):
    """ Basic Acceptance test for Backup rule configuration """

    def __init__(self):
        """
       Initializing the Test case file
        """
        super(TestCase, self).__init__()
        self.name = "Basic Acceptance Test Backup window in AdminConsole"
        self.product = self.products_list.COMMSERVER
        self.feature = self.features_list.ADMINCONSOLE
        self.show_to_user = False
        self.utils = TestCaseUtils(self)
        self.browser = None
        self.operation_window_obj = None
        self.admin_console = None
        self.tcinputs = {
            "operation_rule_name": None,
            "new_operation_rule_name": None,
            "start_date_combo_list": None,
            "end_date_combo_list": None,
            "company": None
            }

    def run(self):

        try:
            self.log.info("Started executing {0} testcase".format(self.id))
            self.log.info("*" * 10 + " Initialize browser objects " + "*" * 10)

            factory = BrowserFactory()
            self.browser = factory.create_browser_object()
            self.browser.open()

            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                     self.inputJSONnode['commcell']['commcellPassword'])
            self.operation_window_obj = OperationWindowMain(self.admin_console)

            start_date_list = ast.literal_eval(self.tcinputs['start_date_combo_list'])
            end_date_list = ast.literal_eval(self.tcinputs['end_date_combo_list'])

            self.operation_window_obj.operation_rule_name = self.tcinputs['operation_rule_name']
            self.operation_window_obj.start_date = start_date_list[0]
            self.operation_window_obj.end_date = end_date_list[0]

            self.operation_window_obj.create_operation_rule()
            self.log.info("Backup rule created successfully")

            self.operation_window_obj.validate_operation_rule()
            self.log.info("initial validation for operation rule is successfully completed")

            self.operation_window_obj.operation_rule_name = self.tcinputs['new_operation_rule_name']
            self.operation_window_obj.start_date = [start_date_list[1]]
            self.operation_window_obj.end_date = [end_date_list[1]]

            self.operation_window_obj.operation_day = dict.fromkeys(['Tuesday', 'Thursday', 'Saturday'], 1)
            self.operation_window_obj.operation_day.update(dict.fromkeys(['Monday', 'Wednesday',
                                                                          'Friday', 'Sunday'], 0))
            self.operation_window_obj.operation_time = dict.fromkeys(['6', '7', '8', '9', '10', '11', '12'
                                                                      , '13', '21', '22', '23'], 1)
            self.operation_window_obj.operation_time.update(dict.fromkeys(['0', '1', '2', '3', '4',
                                                                           '14', '15', '16', '17',
                                                                           '18'], 0))
            self.operation_window_obj.company = self.tcinputs['company']
            self.operation_window_obj.backup_operations = {'Full': '0',
                                                           'Incremental and Differential': '1',
                                                           'Synthetic Full': '1'}

            self.operation_window_obj.modify_operation_rule()
            self.log.info("Backup rule edited successfully")

            self.operation_window_obj.validate_operation_rule()
            self.log.info("Validation for operation rule after editing is successfully completed")

            self.operation_window_obj.start_date = [start_date_list[0]]
            self.operation_window_obj.end_date = [end_date_list[1]]

            self.operation_window_obj.modify_operation_rule()

            self.operation_window_obj.start_date = [start_date_list[1]]
            self.operation_window_obj.end_date = [end_date_list[0]]

            self.operation_window_obj.modify_operation_rule()
            self.log.info("Multiple editing verified successfully")

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

    def tear_down(self):
        """ To clean-up the test case environment created """
        try:

            self.operation_window_obj.del_operation_rule()

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)

        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
