# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing testcase 51515

TestCase is the only class defined in this file

TestCase: Class for executing this testcase

TestCase:
    __init__()      --  Initializes test case class object

    setup()       --  Setup function for this testcase

    run()           --  Main funtion for testcase execution

"""
# Test Suite Imports
from AutomationUtils.cvtestcase import CVTestCase
from Server.Workflow.workflowhelper import WorkflowHelper
from Web.Common.cvbrowser import (
    Browser, BrowserFactory)
from Web.WebConsole.webconsole import WebConsole
from Web.WebConsole.Forms.forms import Forms

class TestCase(CVTestCase):

    """Class for validating Conditional Transitions"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "WORKFLOW - Validate Conditional Transitions"
        self._workflowhelper = None
        self.webconsole = None
        self.browser = None
        self.workflow_name = 'WF_CONDITIONALTRANSITION'

    def setup(self):
        """Setup function of this test case"""
        self._workflowhelper = WorkflowHelper(self, self.workflow_name)

    def run(self):
        """Main function of this testcase execution"""
        try:
            _ = self._workflowhelper.execute(
                {
                    'INP_WORKFLOW_NAME': self.workflow_name,
                }, wait_for_job=False)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.webconsole = WebConsole(self.browser, self.commcell.webconsole_hostname)
            self.webconsole.login(
                self.inputJSONnode['commcell']['commcellUsername'],
                self.inputJSONnode['commcell']['commcellPassword']
            )
            self.webconsole.wait_till_load_complete()
            self.webconsole.goto_forms()
            forms = Forms(self.webconsole)
            forms._goto_Actions()
            forms._goto_Open_Actions()
            forms._open_Action('condition1')
            forms._webconsole.wait_till_load_complete()
            forms.click_action_button('OK')
            forms._webconsole.wait_till_load_complete()
            forms.click_action_button('OK')
            self._workflowhelper.workflow_job_status(self.workflow_name)

        except Exception as excp:
            self.log.info("Exception raise %s", format(excp))
            self._workflowhelper.test.fail(excp)

        finally:
            self._workflowhelper.cleanup()
            WebConsole.logout_silently(self.webconsole)
            Browser.close_silently(self.browser)
