# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import VsaTestCaseUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of VSA  backup
    and Restore test case - v2 Indexing"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "VSA VMWARE Incremental Backup and Restore Cases for v2 indexing"
        self.tc_utils = VsaTestCaseUtils.VSATestCaseUtils(self,
                                                          self.products_list.VIRTUALIZATIONVMWARE,
                                                          self.features_list.DATAPROTECTION)
        self.ind_status = True
        self.failure_msg = ''

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = self.tc_utils.initialize(self)
            backup_options = self.tc_utils.run_backup(self,
                                                      backup_type='INCREMENTAL',
                                                      msg='v2 Streaming Incremental Backup')

            vm_restore_options = self.tc_utils. \
                run_virtual_machine_restore(self,
                                            power_on_after_restore=True,
                                            unconditional_overwrite=True,
                                            msg='FULL VM out of place restore from parent ')

            self.tc_utils.run_disk_restore(self, msg='Disk restores from Parent')

            self.tc_utils.run_attach_disk_restore(self, msg='Attach disk restores from Parent')

            self.tc_utils.run_guest_file_restore(self,
                                                 child_level=True,
                                                 msg='Guest Files restores from Child')

            self.tc_utils.run_disk_restore(self, child_level=True,
                                           msg='disk restores from Child')

            self.tc_utils.run_attach_disk_restore(self,
                                                  child_level=True,
                                                  msg='Attach disk restores from Child')

            vm_restore_options = self.tc_utils. \
                run_virtual_machine_restore(self,
                                            child_level=True,
                                            msg='FULL VM out of Place restores from Child')

        except Exception:
            pass

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                auto_subclient.post_restore_clean_up(vm_restore_options)
            except Exception:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
            if not self.ind_status:
                self.result_string = self.failure_msg
                self.status = constants.FAILED
