# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
Testcase to validate Metrics single commcell user
"""

from AutomationUtils.cvtestcase import CVTestCase

from Reports.utils import TestCaseUtils

from Web.Common.cvbrowser import (
    Browser, BrowserFactory
)
from Web.Common.page_object import TestStep
from Web.WebConsole.Reports.navigator import Navigator
from Web.WebConsole.webconsole import WebConsole
from Web.WebConsole.Reports.monitoringform import ManageCommcells

from Web.Common.exceptions import CVTestCaseInitFailure
from Web.Common.exceptions import CVTestStepFailure
from Web.Common.exceptions import CVWebAutomationException


class TestCase(CVTestCase):
    """Testcase to verify backward compatibility of Metrics Collection queries"""
    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Metrics: Single commcell user validation"
        self.webconsole = None
        self.navigator = None
        self.browser = None
        self.utils = TestCaseUtils(self)
        self.tcinputs = {
            "single_commcell_user": None,
            "password": None
        }

    def init_tc(self):
        """ Initial configuration for the test case. """
        try:
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.webconsole = WebConsole(self.browser, self.commcell.webconsole_hostname)
            self.utils.webconsole = self.webconsole
            self.webconsole.login(self.tcinputs["single_commcell_user"], self.tcinputs["password"])
            self.navigator = Navigator(self.webconsole)
            self.webconsole.goto_commcell_dashboard()
            if self.navigator.is_it_single_commcell() is False:
                cc_count = self.navigator.get_commcell_count()
                raise CVTestCaseInitFailure(
                    "Single user account needed for this Testcase, "
                    f"user [{self.tcinputs['single_commcell_user']}] has {cc_count} CommCells"
                )

        except Exception as exception:
            raise CVTestCaseInitFailure(exception)

    @test_step
    def verify_commcell_dashboard(self):
        """Verify CommCell level dashboard is visible by default"""
        title = self.navigator.get_title()
        self.navigator.goto_worldwide_commcells()
        commcell_list = ManageCommcells(self.webconsole)
        cc_list = commcell_list.get_column_values(column_name='CommCell Name')
        if len(cc_list) != 1:
            raise CVTestCaseInitFailure(
                f"Expected commcell count in monitoring page is 1 but [{len(cc_list)}] are shown"
            )
        cc_name = cc_list[0]
        if title == cc_name:
            raise CVTestStepFailure(
                f"Expected tile is CommCell Name [{cc_name}] but it is {title}"
            )

    @test_step
    def custom_report_visible(self):
        """Verify Custom reports are visible in commcell level report page also"""
        custom_report = 'Backup job summary'
        try:
            self.navigator.goto_commcell_reports(report_name=custom_report)
        except CVWebAutomationException:
            raise CVTestStepFailure(
                f"Custom Report [{custom_report}] not found on CommCell level Reports page"
            )

    def run(self):
        try:
            self.init_tc()
            self.verify_commcell_dashboard()
            self.custom_report_visible()

        except Exception as err:
            self.utils.handle_testcase_exception(err)
        finally:
            WebConsole.logout_silently(self.webconsole)
            Browser.close_silently(self.browser)
