from time import time

from AutomationUtils import logger
from AutomationUtils.config import get_config
from AutomationUtils.cvtestcase import CVTestCase

from Web.Common.cvbrowser import BrowserFactory
from Web.Common.cvbrowser import Browser
from Web.Common.exceptions import CVTestCaseInitFailure
from Web.Common.page_object import TestStep
from Web.Common.exceptions import CVTestStepFailure


from Web.WebConsole.webconsole import WebConsole
from Web.WebConsole.Reports.Metrics.commcellgroup import CommcellGroup
from Web.WebConsole.Reports.navigator import Navigator

from Reports.utils import TestCaseUtils

_CONFIG = get_config()


class TestCase(CVTestCase):

    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Metrics CommCell Group: Validate group creation with no CommCell"
        self.applicable_os = self.os_list.WINDOWS
        self.product = self.products_list.METRICSREPORTS
        self.feature = self.features_list.WEBCONSOLE
        self.show_to_user = True
        self.log = logger.get_log()
        self.browser: Browser = None
        self.webconsole: WebConsole = None
        self.commcell_group: CommcellGroup = None
        self.navigator: Navigator = None
        timestamp = int(time())
        self.COMMCELL_GROUP_NAME = 'Automated_commcellGroup' + str(timestamp)

    def init_tc(self):
        try:
            self.utils = TestCaseUtils(self)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.webconsole = WebConsole(self.browser, self.commcell.webconsole_hostname)
            self.webconsole.login()
            self.commcell_group = CommcellGroup(self.webconsole)
            self.navigator = Navigator(self.webconsole)
            self.webconsole.goto_reports()
            self.navigator.goto_commcell_group()
        except Exception as e:
            raise CVTestCaseInitFailure(e) from e

    @test_step
    def create_empty_commcell_group(self):
        """Creation of the commcell group with empty commcell"""
        self.commcell_group.create(self.COMMCELL_GROUP_NAME)

    @test_step
    def validate_empty_group(self):
        """Validate empty commcell group created now"""
        ret = self.commcell_group.is_group_exist(self.COMMCELL_GROUP_NAME)
        if ret is False:
            raise CVTestStepFailure(
                "Commcell group %s created now doesn't exist in Group listing page"
                % self.COMMCELL_GROUP_NAME)
        cc_count = self.commcell_group.commcell_count_of_group(self.COMMCELL_GROUP_NAME)
        if int(cc_count) != 0:
            raise CVTestStepFailure(
                "commcell group has %d commcells, instead of zero commcells " % cc_count)

    @test_step
    def validate_commcells_in_group(self):
        """Validate the commcells page is showing correct message in this empty group"""
        self.navigator.goto_commcell_group(self.COMMCELL_GROUP_NAME)
        self.navigator.goto_commcells_in_group()
        label = self.commcell_group.get_nodata_notification()
        if label == ("No data available in this report. "
                     "Please ensure at least one registered CommCell"
                     " is associated with this CommCell Group."):
            self.log.info("Correct message is shown for the commcells page")
        else:
            raise CVTestStepFailure(
                "Correct message is not shown, instead %s text is shown " % label)

    def run(self):
        try:
            self.init_tc()
            self.create_empty_commcell_group()
            self.validate_empty_group()
            self.validate_commcells_in_group()

        except Exception as err:
            self.utils.handle_testcase_exception(err)
        finally:
            self.navigator.goto_commcell_group()
            self.commcell_group.delete(self.COMMCELL_GROUP_NAME)
            WebConsole.logout_silently(self.webconsole)
            Browser.close_silently(self.browser)
