# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""
TestCase to validate Cloud Metrics UploadNow operation from CommServe

TestCase:
    setup()                    --  initializes objects required for this TestCase

    validate_cloud_uploadnow() --  Validates Cloud Metrics uploadNow operation

    run()           -          --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from Web.Common.page_object import TestStep

from Reports.utils import TestCaseUtils

from cvpysdk.metricsreport import CloudMetrics


class TestCase(CVTestCase):
    """TestCase to validate Cloud Metrics UploadNow operation from CommServe"""
    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Cloud Metrics Upload Now"
        self.show_to_user = True
        self.cloud_metrics = None
        self.utils = TestCaseUtils(self)

    def setup(self):
        """Intializes cloud metrics object required for this testcase"""
        self.cloud_metrics = CloudMetrics(self.commcell)
        self.cloud_metrics.enable_all_services()

    @test_step
    def validate_cloud_uploadnow(self):
        """Validates Cloud Metrics uploadNow operation"""
        self.log.info('Initiating Cloud Metrics upload now')
        self.cloud_metrics.upload_now()
        self.cloud_metrics.wait_for_uploadnow_completion()
        self.log.info('Cloud Metrics upload now completed Successfully')

    def run(self):
        try:
            self.validate_cloud_uploadnow()
        except Exception as error:
            self.utils.handle_testcase_exception(error)
