// Package commvault implements the Azure ARM Commvault service API version V3.
//
//
package commvault

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"net/http"
	"net/url"
	"os"
	"strings"

	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultBaseURI is the default URI used for the service Commvault
	DefaultBaseURI = "http://WebserverUrl.Commvault.com/webconsole/api"
)

// BaseClient is the base client for Commvault.
type BaseClient struct {
	autorest.Client
	BaseURI string
}

// New creates an instance of the BaseClient client.
func New() BaseClient {
	return NewWithBaseURI(DefaultBaseURI)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string) BaseClient {
	return BaseClient{
		Client:  NewClientWithCustom(),
		BaseURI: baseURI,
	}
}

//WithCustomHeaderSettings Custom setting function to set extra headers
func WithCustomHeaderSettings() autorest.PrepareDecorator {
	return func(p autorest.Preparer) autorest.Preparer {
		return autorest.PreparerFunc(func(r *http.Request) (*http.Request, error) {
			r, err := p.Prepare(r)
			if err == nil {
				if r.Header == nil {
					r.Header = make(http.Header)
				}
				customURL := strings.Replace(r.URL.String(), "http://WebserverUrl.Commvault.com/webconsole/api", os.Getenv("WebServerURL"), -1)
				r.URL, err = url.Parse(customURL)
				if err != nil {
					return r, err
				}
				r.Header.Set(http.CanonicalHeaderKey("Accept"), "application/json")
				r.Header.Set(http.CanonicalHeaderKey("Authtoken"), os.Getenv("Authtoken"))
			}
			return r, err
		})
	}
}

//NewClientWithCustom is to return with customheadersettings
func NewClientWithCustom() autorest.Client {
	return autorest.Client{RequestInspector: WithCustomHeaderSettings()}
}

// EnvironmentSetupRequest ...
type EnvironmentSetupRequest struct {
	Password *string `json:"password,omitempty"`
	Username *string `json:"username,omitempty"`
}

// LoginResponse ...
type LoginResponse struct {
	autorest.Response   `json:"-"`
	AliasName           *string   `json:"aliasName,omitempty"`
	UserGUID            *string   `json:"userGUID,omitempty"`
	LoginAttempts       *float64  `json:"loginAttempts,omitempty"`
	RemainingLockTime   *float64  `json:"remainingLockTime,omitempty"`
	SMTPAddress         *string   `json:"smtpAddress,omitempty"`
	UserName            *string   `json:"userName,omitempty"`
	ProviderType        *float64  `json:"providerType,omitempty"`
	Ccn                 *float64  `json:"ccn,omitempty"`
	Token               *string   `json:"token,omitempty"`
	Capability          *float64  `json:"capability,omitempty"`
	ForcePasswordChange *bool     `json:"forcePasswordChange,omitempty"`
	IsAccountLocked     *bool     `json:"isAccountLocked,omitempty"`
	ErrList             *[]string `json:"errList,omitempty"`
}
