# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Helper file to maintain all the constants used by REST API test cases"""

import os
import AutomationUtils.constants as AC


ENVIRONMENT_FILE = os.path.join(AC.AUTOMATION_DIRECTORY, 'Server',
                                'RESTAPI', 'PostmanCollections',
                                'JSONAuto.environment.json')
"""str:     Path for the location of environment file"""

COLLECTION_FILE = os.path.join(AC.AUTOMATION_DIRECTORY, 'Server',
                               'RESTAPI', 'PostmanCollections')
"""str:     Path for the location of postman collection files"""

TEMP_ENVIRONMENT_FILE = os.path.join(AC.AUTOMATION_DIRECTORY, 'Server',
                                     'RESTAPI', 'PostmanCollections',
                                     'JSONAuto_modified.environment.json')
"""str:     Path for the location of temporary environment file"""

NEWMAN_LOG_LOCATION = os.path.join(AC.LOG_DIR, 'NewmanLogFiles')
"""str:     Path for generating newman log files"""
