
import pandas as pd
import os
import time
import smtplib
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.mime.base import MIMEBase
from email import encoders
import subprocess
import pandas as pd
import matplotlib.pyplot as plt
import graph_analysis as graph
from datetime import datetime

'''
Please run this python file using the command 'python locust_tool.py' in the terminal.
It will ask the hostname (eg: abc.idcprodcert.loc), users (eg: 3) and spawn rate (eg: 1) and email-id(s) 
(eg: v@commvault.com, s@commvault.com).
It will then give the list of apis that can be executed and prompt you to provide the numbers
corresponding to the api. Enter the api numbers in the sequence in which they must be executed.
Enter stop when you have provided sufficient number of APIs.
It then ask the username and password to access the commcell and begin execution. 
Reports will be sent to email provided. It will contain median time of execution, successful requests
and failed requests.
'''

# gets the present date and time
cmd = str(time.asctime(time.localtime(time.time()))).replace(" ", "_").replace(":", "_")

# User inputs for headless execution of locust
hostname = str(input("Hostname: "))
threads = str(input("Number of threads: "))
numThreads = str(input("Spawn rate: "))
minutes = str(input("Enter Run Time in Minutes: "))
seconds = int(minutes)*60
mailList = input("Enter the email addresses to send report to: ").split(", ")

# Stores all the generated reports to folder CSV_Reports
path = os.getcwd()
if not os.path.exists('CSV_Reports'):
    os.makedirs('CSV_Reports')
os.system('cd CSV_Reports & mkdir '+str(cmd)+' & cd ..')

#get automation path
process = subprocess.Popen('locust -f \"UI.py\" --csv='+cmd+' --headless --host http://'+hostname+' -u '+threads+' -r '+numThreads+' --run-time '+minutes+'m')
time.sleep(int(seconds))
process.kill()

graph.generate_med(str(cmd)+"_stats.csv",str(cmd)+"_med.png")
graph.generate_req(str(cmd)+"_stats.csv",str(cmd)+"_req.png")
graph.generate_fail(str(cmd)+"_stats.csv",str(cmd)+"_fail.png")

time.sleep(2)
os.system('move *.csv CSV_Reports\\'+str(cmd))
os.system('move '+str(cmd)+'*.png CSV_Reports\\'+str(cmd))

time.sleep(10)

# Email is generated consisting of the CSV stats report and charts
fromaddr = "locust@commvault.com"
toaddr = mailList

msg = MIMEMultipart()

msg['From'] = fromaddr
msg['To'] = ", ".join(toaddr)
msg['Subject'] = "Locust Testing"

body = '''Hi,

Please find the report for the latest locust run.

Thank you!
'''

msg.attach(MIMEText(body, 'plain'))

filename = str(cmd)+"_stats.csv"
medname = str(cmd)+"_med.png"
reqname = str(cmd)+"_req.png"
failname = str(cmd)+"_fail.png"
file_list = [filename, medname,reqname,failname]

for f in file_list:

    attachment = open(str(path)+'\\CSV_Reports\\'+str(cmd)+'\\'+str(f), "rb")
    part = MIMEBase('application', 'octet-stream')
    part.set_payload(attachment.read())
    encoders.encode_base64(part)
    part.add_header('Content-Disposition', "attachment; filename= %s" % f)
    msg.attach(part)

server = smtplib.SMTP("mail.commvault.com")
text = msg.as_string()
server.sendmail(fromaddr, toaddr, text)
server.quit()





