from optparse import OptionParser
import os
from os.path import basename
import matplotlib.pyplot as plt
import numpy as np

def autolabelh(rects):
    for rect in rects:
        width = rect.get_width()
        plt.text(width * 1.05, rect.get_y() + rect.get_height() / 2., '%d' % int(width), ha='left', va='center', fontdict={'size': 10})


def generate_med(file_name, img_file):
    # converts CSV to a 2D array
    data = np.genfromtxt(fname=file_name, dtype=None, delimiter=',', names=True, autostrip=True)
    # get name and median response time header
    headers = data.dtype.names
    name_header, response_header = headers[1], headers[4]
    # sorting data according to median response time
    sorted_data = np.sort(data, order=[response_header])
    name, median_response_time = sorted_data[name_header], sorted_data[response_header]
    name1 = [i.decode("utf-8") for i in name]
    # plots a bargraph
    bar = plt.barh(range(len(median_response_time)), median_response_time, align='edge', alpha=0.7)
    # adds names of the requests along the y-axis
    plt.yticks(range(len(name1)), name1, ha='right', va='bottom', size='small')
    plt.subplots_adjust(left=0.3)
    plt.grid(True)
    autolabelh(bar)
    title = "Median Response Time For Each Request"
    plt.suptitle(title, fontsize=12, weight='bold')
    plt.savefig(img_file, bbox_inches='tight')
    plt.close()


def generate_req(file_name, img_file):
    # converts CSV to a 2D array
    data = np.genfromtxt(fname=file_name, dtype=None, delimiter=',', names=True, autostrip=True)
    # get name and median response time header
    headers = data.dtype.names
    name_header, response_header = headers[1], headers[2]
    # sorting data according to median response time
    sorted_data = np.sort(data, order=[response_header])
    name, median_response_time = sorted_data[name_header], sorted_data[response_header]
    name1 = [i.decode("utf-8") for i in name]
    # plots a bargraph
    bar = plt.barh(range(len(median_response_time)), median_response_time, align='edge', alpha=0.7)
    # adds names of the requests along the y-axis
    plt.yticks(range(len(name1)), name1, ha='right', va='bottom', size='small')
    plt.subplots_adjust(left=0.3)
    plt.grid(True)
    autolabelh(bar)
    title = "Total Number of Requests"
    plt.suptitle(title, fontsize=12, weight='bold')
    plt.savefig(img_file, bbox_inches='tight')
    plt.close()


def generate_fail(file_name, img_file):
    # converts CSV to a 2D array
    data = np.genfromtxt(fname=file_name, dtype=None, delimiter=',', names=True, autostrip=True)
    # get name and median response time header
    headers = data.dtype.names
    name_header, response_header = headers[1], headers[3]
    # sorting data according to median response time
    sorted_data = np.sort(data, order=[response_header])
    name, median_response_time = sorted_data[name_header], sorted_data[response_header]
    name1 = [i.decode("utf-8") for i in name]
    # plots a bargraph
    bar = plt.barh(range(len(median_response_time)), median_response_time, align='edge', alpha=0.7)
    # adds names of the requests along the y-axis
    plt.yticks(range(len(name1)), name1, ha='right', va='bottom', size='small')
    plt.subplots_adjust(left=0.3)
    plt.grid(True)
    autolabelh(bar)
    title = "Total Number of Failures"
    plt.suptitle(title, fontsize=12, weight='bold')
    plt.savefig(img_file, bbox_inches='tight')
    plt.close()

# generate2("Tue_Jul_28_23_37_21_2020_stats.csv", "failures.png")