from middle import *
import variable as variable
import json
from locust import HttpUser, constant, SequentialTaskSet, task, TaskSet
from random import *
import time
import base64
from API import *
#Returns the list of available APIs so that the user can pick order of execution
val = make_list(API)
dict_func = get_api(val)
only_call = eval_func(dict_func)

#Takes in commcell credentials to start execution
username = str(input("Enter the username: "))
password = str(input("Enter the password: "))

#Converts password to base64 format
sample_string_bytes = password.encode("ascii") 
base64_bytes = base64.b64encode(sample_string_bytes) 
base64_password = base64_bytes.decode("ascii") 



class Locust(SequentialTaskSet):
    # Logs in the user
    def on_start(self):
        # first request
        print("LOGIN USER")
        headers = {'content-type': 'application/json', 'Accept-Encoding': 'gzip', 'Accept': 'application/json'}
        response = self.client.post("/webconsole/api/Login", data=json.dumps({
            "mode": 4,
            "username": username,
            "password": base64_password
        }),
                                    headers=headers,
                                    name="Login")
        print("Response status code", response.status_code)
        # print("Response content:", response.text)
        if response.status_code == 200:
            print("Status code is correct!")
            variable.token = response.json().get('token')
            print("Token value:", variable.token)
        else:
            print("User Not logged in!")

    #list of APIs to execute
    tasks = only_call

    #terminates execution by logging out
    def on_stop(self):
        print("LOGOUT")
        headers = {'Accept-Encoding': 'gzip', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = self.client.post("/webconsole/api/Logout", headers=headers, name="Logout")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            logout_message = response.json()
            print("response:", logout_message)


class User(HttpUser):
    tasks = [Locust]
    wait_time = constant(1)
