import json
import time
import variable as variable
from random import *
import string

class API:

    def get_plan(self,taskset):
        print("GET DETAILS OF PLANS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get("/webconsole/api/v2/Plan",
                                    headers=headers,
                                    name="Get Plans")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_users(self,taskset):
        print("GET DETAILS OF USERS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get("/webconsole/api/User",
                                    headers=headers,
                                    name="Get Users")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_pools(self,taskset):
        print("GET DETAILS OF STORAGE POOLS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get("/webconsole/api/StoragePool", headers=headers, name="Get Storage Pool")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def create_plan(self,taskset):
        print("CREATE A NEW PLAN")
        headers = {'Content-Type': 'application/json', 'Accept-Encoding': 'gzip', 'Accept': 'application/json',
                'Authtoken': variable.token}
        response = taskset.client.post("/webconsole/api/v2/Plan", data=json.dumps(
            {
                "plan": {
                    "summary": {
                        "slaInMinutes": 240,
                        "description": "att-3 plan",
                        "restrictions": 1,
                        "type": 2,
                        "subtype": 33554437,
                        "planOwner": {
                            "userName": "admin",
                            "userId": 1
                        },
                        "plan": {
                            "planName": "plan" + str(time.time())
                        }
                    },
                    "inheritance": {
                        "isSealed": True
                    },
                    "storage": {
                        "storagePolicy": {},
                        "copy": [
                            {
                                "active": 1,
                                "isDefault": 1,
                                "dedupeFlags": {
                                    "enableDASHFull": 1,
                                    "useGlobalDedupStore": 1,
                                    "enableDeduplication": 1,
                                    "enableClientSideDedup": 1
                                },
                                "storagePolicyFlags": {
                                    "blockLevelDedup": 1
                                },
                                "retentionRules": {
                                    "retainBackupDataForDays": 30,
                                    "retentionFlags": {
                                        "enableDataAging": 1
                                    }
                                },
                                "useGlobalPolicy": {
                                    "storagePolicyName": variable.storagePoolName,
                                    "storagePolicyId": 0
                                }
                            }
                        ]
                    },
                    "schedule": {
                        "task": {
                            "taskType": 4,
                            "taskFlags": {
                                "isEdgeDrive": False,
                                "isEZOperation": False,
                                "disabled": False
                            }
                        },
                        "subTasks": [
                            {
                                "subTask": {
                                    "subTaskName": "Daily Incremental",
                                    "subTaskType": 2,
                                    "flags": 65536,
                                    "operationType": 2,
                                    "subTaskId": 1
                                },
                                "pattern": {
                                    "freq_subday_interval": 14400,
                                    "freq_type": 4,
                                    "active_end_time": 86340,
                                    "active_start_time": 0,
                                    "freq_interval": 1,
                                    "name": "Daily Incremental",
                                    "freq_recurrence_factor": 1
                                },
                                "options": {
                                    "backupOpts": {
                                        "bkpLatestVersion": True,
                                        "backupLevel": 2,
                                        "incLevel": 1,
                                        "runIncrementalBackup": True,
                                        "doNotTruncateLog": False,
                                        "cdrOptions": {
                                            "incremental": True,
                                            "dataVerificationOnly": False,
                                            "full": False
                                        },
                                        "dataOpt": {
                                            "stopWinService": True,
                                            "stopDhcpService": True,
                                            "useCatalogServer": True,
                                            "optimizedBackup": True,
                                            "followMountPoints": True,
                                            "bkpFilesProctedByFS": True,
                                            "granularrecovery": True,
                                            "verifySynthFull": True,
                                            "daysBetweenSyntheticBackup": 0
                                        },
                                        "nasOptions": {
                                            "snapShotType": 0,
                                            "backupQuotas": True
                                        },
                                        "vaultTrackerOpt": {
                                            "mediaStatus": {
                                                "bad": True,
                                                "overwriteProtected": True,
                                                "full": True
                                            }
                                        },
                                        "mediaOpt": {
                                            "numberofDays": 30,
                                            "retentionJobType": 2,
                                            "waitForInlineBackupResources": True,
                                            "allowOtherSchedulesToUseMediaSet": True
                                        }
                                    },
                                    "commonOpts": {
                                        "jobRetryOpts": {
                                            "runningTime": {
                                                "totalRunningTime": 3600
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                "subTask": {
                                    "subTaskName": "Last Saturday of the Month Regular Full",
                                    "subTaskType": 2,
                                    "flags": 0,
                                    "operationType": 2,
                                    "subTaskId": 1
                                },
                                "pattern": {
                                    "freq_subday_interval": 0,
                                    "freq_type": 32,
                                    "active_start_time": 72000,
                                    "freq_interval": 7,
                                    "freq_relative_interval": 5,
                                    "name": "Last Saturday of the Month Regular Full",
                                    "freq_recurrence_factor": 1,
                                    "daysToRun": {
                                        "week": 5,
                                        "day": 7
                                    }
                                },
                                "options": {
                                    "backupOpts": {
                                        "truncateLogsOnSource": False,
                                        "sybaseSkipFullafterLogBkp": False,
                                        "bkpLatestVersion": True,
                                        "backupLevel": 1,
                                        "incLevel": 1,
                                        "runIncrementalBackup": True,
                                        "doNotTruncateLog": False,
                                        "vsaBackupOptions": {
                                            "backupFailedVMsOnly": False
                                        },
                                        "cdrOptions": {
                                            "incremental": False,
                                            "dataVerificationOnly": False,
                                            "full": True
                                        },
                                        "dataOpt": {
                                            "useCatalogServer": True,
                                            "followMountPoints": True,
                                            "enforceTransactionLogUsage": False,
                                            "skipConsistencyCheck": False,
                                            "createNewIndex": True,
                                            "daysBetweenSyntheticBackup": 0,
                                            "autoCopy": False
                                        },
                                        "mediaOpt": {}
                                    },
                                    "commonOpts": {
                                        "perfJobOpts": {}
                                    }
                                }
                            },
                            {
                                "subTask": {
                                    "subTaskName": "Weekly Synthetic Fulls",
                                    "subTaskType": 2,
                                    "flags": 0,
                                    "operationType": 2,
                                    "subTaskId": 1
                                },
                                "pattern": {
                                    "freq_subday_interval": 0,
                                    "freq_type": 8,
                                    "active_start_time": 72000,
                                    "freq_interval": 32,
                                    "name": "Weekly Synthetic Fulls",
                                    "freq_recurrence_factor": 1,
                                    "daysToRun": {
                                        "Monday": False,
                                        "Thursday": False,
                                        "Friday": True,
                                        "Sunday": False,
                                        "Wednesday": False,
                                        "Tuesday": False,
                                        "Saturday": False
                                    },
                                    "repeatPattern": [
                                        {
                                            "exception": True,
                                            "onDay": 64,
                                            "occurrence": 16
                                        }
                                    ]
                                },
                                "options": {
                                    "backupOpts": {
                                        "truncateLogsOnSource": False,
                                        "sybaseSkipFullafterLogBkp": False,
                                        "bkpLatestVersion": True,
                                        "backupLevel": 4,
                                        "incLevel": 1,
                                        "runIncrementalBackup": True,
                                        "doNotTruncateLog": False,
                                        "vsaBackupOptions": {
                                            "backupFailedVMsOnly": False
                                        },
                                        "cdrOptions": {
                                            "incremental": False,
                                            "dataVerificationOnly": False,
                                            "full": False
                                        },
                                        "dataOpt": {
                                            "useCatalogServer": True,
                                            "followMountPoints": True,
                                            "enforceTransactionLogUsage": False,
                                            "skipConsistencyCheck": False,
                                            "createNewIndex": True,
                                            "daysBetweenSyntheticBackup": 0,
                                            "autoCopy": False
                                        },
                                        "mediaOpt": {}
                                    },
                                    "commonOpts": {
                                        "perfJobOpts": {}
                                    }
                                }
                            },
                            {
                                "subTask": {
                                    "subTaskName": "Daily aux copy",
                                    "subTaskType": 1,
                                    "flags": 0,
                                    "operationType": 4003,
                                    "subTaskId": 1
                                },
                                "pattern": {
                                    "freq_subday_interval": 1800,
                                    "freq_type": 4,
                                    "active_end_time": 86340,
                                    "active_start_time": 0,
                                    "freq_interval": 1,
                                    "name": "Daily aux copy",
                                    "freq_recurrence_factor": 1
                                },
                                "options": {
                                    "backupOpts": {
                                        "bkpLatestVersion": True,
                                        "backupLevel": 2,
                                        "incLevel": 1,
                                        "runIncrementalBackup": True,
                                        "doNotTruncateLog": False,
                                        "cdrOptions": {
                                            "incremental": True,
                                            "dataVerificationOnly": False,
                                            "full": False
                                        },
                                        "dataOpt": {
                                            "stopWinService": True,
                                            "stopDhcpService": True,
                                            "useCatalogServer": True,
                                            "optimizedBackup": True,
                                            "followMountPoints": True,
                                            "bkpFilesProctedByFS": True,
                                            "granularrecovery": True,
                                            "verifySynthFull": True,
                                            "daysBetweenSyntheticBackup": 0
                                        },
                                        "nasOptions": {
                                            "snapShotType": 0,
                                            "backupQuotas": True
                                        },
                                        "vaultTrackerOpt": {
                                            "mediaStatus": {
                                                "bad": True,
                                                "overwriteProtected": True,
                                                "full": True
                                            }
                                        },
                                        "mediaOpt": {
                                            "numberofDays": 30,
                                            "retentionJobType": 2,
                                            "waitForInlineBackupResources": True,
                                            "allowOtherSchedulesToUseMediaSet": True
                                        }
                                    },
                                    "commonOpts": {
                                        "jobRetryOpts": {
                                            "runningTime": {
                                                "totalRunningTime": 3600
                                            }
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    "options": {
                        "quota": 0
                    }
                }
            }
        ),
                                    headers=headers,
                                    name="Create Plan")

        print("Response status code", response.status_code)
        print("Response content:", response.json())
        if response.status_code == 200:
            print("status code is 200")
            variable.planId = response.json()['plan']['summary']['plan']['planId']
            variable.planName = response.json()['plan']['summary']['plan']['planName']
            planId = response.json()['plan']['summary']['plan']['planId']
            variable.plan_list.append(planId)
            print(variable.planId)
            print(variable.planName)

    def create_organization(self, taskset):
        print("CREATE A NEW ORGANIZATION")
        headers = {'Content-Type': 'application/json', 'Accept-Encoding': 'gzip', 'Accept': 'application/json',
                   'Authtoken': variable.token}
        response = taskset.client.post("/webconsole/api/Organization", data=json.dumps(
            {
                "organizationInfo": {
                    "planDetails": [
                        {
                            "numCopies": 2,
                            "description": "Server plan",
                            "type": 2,
                            "numDevices": 0,
                            "subtype": 33554437,
                            "isElastic": False,
                            "numAssocEntities": 0,
                            "restrictions": 1,
                            "numCompanies": 37,
                            "planStatusFlag": 0,
                            "rpoInMinutes": 86400,
                            "numUsers": 0,
                            "permissions": [
                                {
                                    "permissionId": 31,
                                    "entityInfo": {
                                        "companyId": 0,
                                        "companyName": "",
                                        "multiCommcellId": 0
                                    }
                                },
                                {
                                    "permissionId": 157,
                                    "entityInfo": {
                                        "companyId": 0,
                                        "companyName": "",
                                        "multiCommcellId": 0
                                    }
                                },
                                {
                                    "permissionId": 158,
                                    "entityInfo": {
                                        "companyId": 0,
                                        "companyName": "",
                                        "multiCommcellId": 0
                                    }
                                },
                                {
                                    "permissionId": 159,
                                    "entityInfo": {
                                        "companyId": 0,
                                        "companyName": "",
                                        "multiCommcellId": 0
                                    }
                                }
                            ],
                            "plan": {
                                "planSubtype": 33554437,
                                "_type_": 158,
                                "planType": 2,
                                "planSummary": "RPOHours:1440,NumberOfCopies:2,AssociatedEntitiesCount:0",
                                "planName": variable.company_plan,
                                "planId": 0,
                                "entityInfo": {
                                    "companyId": 0,
                                    "companyName": "",
                                    "multiCommcellId": 0
                                }
                            },
                            "planOwner": {
                                "_type_": 13,
                                "userName": "Administrator",
                                "userId": 1,
                                "entityInfo": {
                                    "companyId": 0,
                                    "companyName": "",
                                    "multiCommcellId": 0
                                }
                            }
                        }

                    ],
                    "organization": {
                        "connectName": "newman"+str(''.join(choice(string.ascii_lowercase) for i in range(4))),
                        "emailDomainNames": [
                            "commvault.com"
                        ],
                        "shortName": {
                            "domainName": "newman"+str(''.join(choice(string.ascii_lowercase) for i in range(4)))
                        }
                    },
                    "organizationProperties": {
                        "primaryDomain": "",
                        "primaryContacts": [
                            {
                                "fullName": "newman"+str(''.join(choice(string.ascii_lowercase) for i in range(4))),
                                "email": "newman"+str(''.join(choice(string.ascii_lowercase) for i in range(4)))+"@commvault.com"
                            }
                        ]
                    }
                }
            }
        ),
                                       headers=headers,
                                       name="Create Organization")

        print("Response status code", response.status_code)
        print("Response content:", response.json())
        if response.status_code == 200:
            print("status code is 200")

    def create_storagePool(self, taskset):
        print("CREATE A NEW STORAGE POOL")
        headers = {'Content-Type': 'application/json', 'Accept-Encoding': 'gzip', 'Accept': 'application/json',
                   'Authtoken': variable.token}
        response = taskset.client.post("/webconsole/api/StoragePool?Action=create", data=json.dumps(
            {
                "storagePolicyName": "StoragePoolCheck"+str(''.join(choice(string.ascii_lowercase) for i in range(4))),
                "type": 1,
                "copyName": "NewStoragePolicyCopyCheck"+str(''.join(choice(string.ascii_lowercase) for i in range(4))),
                "numberOfCopies": 1,
                "clientGroup": {
                    "_type_": 28,
                    "clientGroupId": 0,
                    "clientGroupName": ""
                },
                "storage": [
                    {
                        "path": "C:\\Users\\Administrator\\Desktop\\lib\\storagePool"+str(''.join(choice(string.ascii_lowercase) for i in range(4))),
                        "mediaAgent": {
                            "mediaAgentId": 0,
                            "_type_": 11,
                            "mediaAgentName": variable.mediaAgentName
                        },
                        "credentials": {}
                    }
                ],
                "storagePolicyCopyInfo": {
                    "copyType": 1,
                    "isFromGui": True,
                    "active": 1,
                    "isDefault": 1,
                    "numberOfStreamsToCombine": 1,
                    "dedupeFlags": {
                        "enableDASHFull": 1,
                        "hostGlobalDedupStore": 1,
                        "enableDeduplication": 1
                    },
                    "storagePolicyFlags": {
                        "blockLevelDedup": 1,
                        "enableGlobalDeduplication": 1
                    },
                    "DDBPartitionInfo": {
                        "maInfoList": [
                            {
                                "mediaAgent": {
                                    "mediaAgentId": 0,
                                    "_type_": 11,
                                    "mediaAgentName": variable.mediaAgentName
                                },
                                "subStoreList": [
                                    {
                                        "diskFreeWarningThreshholdMB": 10240,
                                        "diskFreeThresholdMB": 5120,
                                        "accessPath": {
                                            "path": "C:\\Users\\Administrator\\Desktop\\Check1"+str(''.join(choice(string.ascii_lowercase) for i in range(4)))
                                        }
                                    }
                                ]
                            }
                        ]
                    },
                    "library": {
                        "libraryName": variable.libraryName,
                        "_type_": 9,
                        "libraryId": 0
                    },
                    "mediaAgent": {
                        "mediaAgentId": 0,
                        "_type_": 11,
                        "mediaAgentName": variable.mediaAgentName
                    }
                }
            }

        ),
                                       headers=headers,
                                       name="Create Storage Pool")

        print("Response status code", response.status_code)
        print("Response content:", response.json())
        if response.status_code == 200:
            print("status code is 200")

    def get_commcellDetails(self, taskset):
        print("GET DETAILS OF COMMCELL")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/CustomReportsEngine/rest/reportsplusengine/datasets/a0f077a5-2dfe-4010-a957-57a24cae89a8/data",
            headers=headers, name="Get Commcell Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_clientCount(self, taskset):
        print("GET CLIENT COUNT")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/clients/count?type=fileserver,vm,laptop",
            headers=headers, name="Get client count")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_anomalies(self, taskset):
        print("GET ANOMALIES")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/CommServ/Anomaly/Jobs",
            headers=headers, name="Get Anomaly Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_anomalousEntityCount(self, taskset):
        print("GET ANOMALOUS ENTITY COUNT DETAILS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/CommServ/Anomaly/Entity/Count?anomalousEntityType=14",
            headers=headers, name="Get Anomalous Entity Count Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_searchEntity(self, taskset):
        print("GET SEARCH ENTITY DETAILS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/Entities/Search?name=client&pageNum=1&pageSize=4&exactMatch=0",
            headers=headers, name="Get Search Entity Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_basicSearch(self, taskset):
        print("GET BASIC SEARCH DETAILS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/Entities/Search?name=client",
            headers=headers, name="Get Basic Search Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_multicommcell(self, taskset):
        print("GET MULTICOMMCELL SEARCH DETAILS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/CommcellRedirect/Multicommcell",
            headers=headers, name="Get Multicommcell Search Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_searchDetails(self, taskset):
        print("GET SEARCH DETAILS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/Entities/Search?operationType=Archive&name=client&detailedProperty=1",
            headers=headers, name="Get Search Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def get_multicommcellsearch(self, taskset):
        print("GET MULTICOMMCELL SEARCH ENTITY DETAILS")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/Entities/Search?name=client&ismultiCommcellSearch=1",
            headers=headers, name="Get multicommcell search entity Details")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def papi_company(self, taskset):
        print("papi company")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/ag/company/1?showInheritedAssociation",
            headers=headers, name="get papi company")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def papi_user(self, taskset):
        print("papi user")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/ag/user/1",
            headers=headers, name="get papi user")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def papi_userGroup(self, taskset):
        print("papi userGroup")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/ag/usergroup/1",
            headers=headers, name="get papi usergroup")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def papi_role(self, taskset):
        print("papi role")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/ag/role",
            headers=headers, name="get papi role")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def papi_diskStorage(self, taskset):
        print("papi diskStorage")
        headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authtoken': variable.token}
        response = taskset.client.get(
            "/webconsole/api/ag/Storage/Disk/3?showInheritedAssociation",
            headers=headers, name="get papi diskStorage")
        print("Response status code", response.status_code)
        print("Response content:", response.text)
        if response.status_code == 200:
            print("status code is 200")

    def create_user(self, taskset):
        print("CREATE A NEW USER")
        headers = {'Content-Type': 'application/json', 'Accept-Encoding': 'gzip', 'Accept': 'application/json',
                   'Authtoken': variable.token}
        response = taskset.client.post("/webconsole/api/User", data=json.dumps({
            "users":
                [
                    {
                        "description": "User created for load testing",
                        "agePasswordDays": 10,
                        "password": "I0VMbG9Xb3JsZCExMg==",
                        "email": "locustUser" + str(time.time()) + "@locust.com",
                        "fullName": "Locust User",
                        "enableUser": True,
                        "userEntity":
                            {
                                "userName": "locustUser" + str(time.time())
                            }
                    }
                ]
        }),
                                       headers=headers,
                                       name="Create User")

        print("Response status code", response.status_code)
        print("Response content:", response.json())
        if response.status_code == 200:
            print("Created new user")
            print("status code is 200")
            id = response.json()['response'][0]['entity']['userId']

            print("User ID is:", id)
        else:
            print("User creation failed")


a = API()

