# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""

Main file for performing cvfailover operations.

CVFailoverHelper: CVFailover helper class to perform cvfailover related operations

CVFailoverHelper:
    __init__(class_object)  --  initialise object of the CVFailoverHelper class

    run_cvfailover          --  performs CvFailover operation

"""

import subprocess
from cvpysdk.exception import SDKException


class CVFailoverHelper(object):
    """monitoring helper class to perform monitoring related operations"""

    def __init__(self, standalonecs, op_type="Production", log=None):
        """
        Initialises the CVFailoverHelper class with the commcell object

        Args:
            standalonecs (str)    -- name of the standalonecs

            op_type         (str)    -- type of cvfailover type.
                                     It can can be Production,
                                     Production Maintenance,Test.

            log          (Object) -- logger object.
        """
        self.standalonecs = standalonecs
        self.type = op_type
        self.log = log
        self.path = None

    def run_cvfailover(self):
        '''
        This Function will run cv failover.
        Raises:
                SDKException:
                    if failed to perform cvfailover
        '''
        try:
            log = self.log
            log.info("Failover package installed path %s" % self.path)
            cmd = ("GxAdmin.exe -console -failover -execute -type %s" % self.type
                   + " -destNode %s" % self.standalonecs)

            log.info("Command used for CS failover {}".format(cmd))
            batch_file = "C:\\failoverinput.bat"
            file = open(batch_file, "w")
            file.write("cd " + self.path + "\\Base" + "\n")
            file.write(cmd)
            file.close()
            output = subprocess.Popen(batch_file, shell=True, stdout=subprocess.PIPE)
            stdout, stderr = output.communicate()
            if output.returncode != 0 or stdout.decode().find("Failed") >= 0 or stdout.decode().find(
                    "SQL jobs are running") >= 0 or output is None or stdout.decode().find("Failover package is not installed") >= 0:
                raise Exception(
                    "%s CVFailover operation is not successful, error: %s" %
                    self.type %
                    stderr.decode())
            else:
                log.info("%s CVFailover operation is successful" % self.type)

        except Exception as err:
            raise SDKException('Response', '101', err)
