# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
Utilities for custom reports
"""
from AutomationUtils import logger

from Reports.utils import TestCaseUtils


class CustomReportUtils(TestCaseUtils):
    """
    Utilities for custom reports
    """
    def __init__(self, testcase, webconsole=None):
        super().__init__(testcase)
        self.__webconsole = webconsole

    @property
    def webconsole(self):
        """Returns webconsole"""
        if self.__webconsole:
            return self.__webconsole
        return self.testcase.webconsole

    @webconsole.setter
    def webconsole(self, value):
        self.__webconsole = value

    def parse_csv_data(self, filename):
        """parse csv content"""
        data = self.get_csv_content(filename)
        return _ParseCSV(data)

    def get_as_table_formatted_csv(self, filename, strip_title=False, strip=True):
        data = self.get_csv_content(filename)
        if strip_title:
            while len(data[0]) == 1:
                del data[0]
                if len(data[0])>1 and 'Report generated on ' in data[0][0]:
                    del data[0]

        dict_data = dict(zip(data[0], list(zip(*data[1:]))))
        return {
            k.strip(): [v_.strip() for v_ in v]
            for k, v in dict_data.items()
        } if strip else dict_data

    def get_commcell_datasources(self, api=None):
        api_ = api if api else self.cre_api
        commcells_resp = api_.execute_sql("""
            SELECT aliasName
            FROM   app_commcellinfo I 
                   INNER JOIN app_commcell CC 
                           ON I.commcellid = CC.id 
                   LEFT OUTER JOIN (SELECT DISTINCT commcellid 
                                    FROM   grc_commcellprop 
                                    WHERE  propid = 26 
                                           AND longval = 1) T 
                                ON T.commcellid = CC.id 
                   INNER JOIN app_client CL 
                           ON CL.id = CC.clientid 
            WHERE  I.commcellid NOT IN (SELECT commcellid 
                                        FROM   grc_commcellprop 
                                        WHERE  propid = 30 
                                               AND longval = 1) 
        """)
        return [commcell[-1] for commcell in commcells_resp]


class _ParseCSV:
    """Class to get all the necessary details of a parsed CSV dataa"""
    def __init__(self, data):
        self.data = data
        self.log = logger.get_log()

    def get_table_data(self):
        """Returns the content of the table as a dict."""
        try:
            column_name = self.data[3]
            values = self.data[4:]  # TODO: modify here if the csv contains multiple components
            return dict(zip(column_name, map(list, zip(*values))))
        except IndexError:
            err_msg = "Exported CSV is Empty"
            self.log.error(err_msg)
            raise IndexError(err_msg)
