#  -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""constants file to maintain all the constants used by media agent test cases"""

# List of server types used for creating cloud libraries
CLOUD_LIBRARIES = {
    "Direct Glacier": {
        "mountPath": "dummybucket",
        "serverType": 53,
        "loginName": "glacier.us-west-1.amazonaws.com//AKIAIL5IBWEGBL2HSPWA",
        "password": "fs4Cwc/7qqPc2fxzb7Q/urmejqi+Xkn/HyjfJga8"},
    "Amazon S3 Glacier": {
        "mountPath": "Glasiar-0Day",
        "serverType": 2,
        "loginName": "s3.amazonaws.com//AKIAIL5IBWEGBL2HSPWA",
        "password": "fs4Cwc/7qqPc2fxzb7Q/urmejqi+Xkn/HyjfJga8"},
    "MSFT Azure Storage Archive Tier": {
        "mountPath": "azurearchivecml",
        "serverType": 3,
        "loginName": "blob.core.windows.net@3//cvdevblobtest",
        "password": ("higFkVriUSJWu5RItX93vj5jC5ec7E9rpM6dkrjFLm95IjK8eR9B7w+5/c"
                     "AJSePnmFxwfUT33rN6c0YlGcxw/g==")},
    "MSFT Azure Storage Hot-Archive Tier": {
        "mountPath": "azurehotarchivecml",
        "serverType": 3,
        "loginName": "blob.core.windows.net@4//cvdevblobtest",
        "password": ("higFkVriUSJWu5RItX93vj5jC5ec7E9rpM6dkrjFLm95IjK8eR9B7w+5/cAJ"
                     "SePnmFxwfUT33rN6c0YlGcxw/g==")},
    "MSFT Azure Storage Cool-Archive Tier": {
        "mountPath": "azurecoolarchivecml",
        "serverType": 3,
        "loginName": "blob.core.windows.net@5//cvdevblobtest",
        "password": ("higFkVriUSJWu5RItX93vj5jC5ec7E9rpM6dkrjFLm95IjK8eR9B7w+5/cA"
                     "JSePnmFxwfUT33rN6c0YlGcxw/g==")},
    "OCI Archive": {
        "mountPath": "ociarchivecml",
        "serverType": 28,
        "loginName": (
            "objectstorage.us-phoenix-1.oraclecloud.com//commvault|-|ocid1"
            ".tenancy.oc1..aaaaaaaafwywe4fshq5so2vnibrqzpqaj4cebbtmkzw5k5ze325niaoqn5ca|"
            "-|ocid1.user.oc1..aaaaaaaa6agxn4vtrimxps5adi63uql5rn3lfrmihcskzlxjr4yt5tnd"
            "vdbq|-|b5:67:b0:7b:d8:7d:3f:3c:af:b8:75:14:f0:1f:38:5b|-|bmcs_api_key.pem"),
        "password": "######"},
    "Oracle Archive": {
        "mountPath": "oraclearchivecml",
        "serverType": 22,
        "loginName": ("Commvault2.storage.oraclecloud.com/auth/v1.0//Storage-commvault2"
                      ":dratan@commvault.com"),
        "password": "######"},
}

CLOUD_SERVER_TYPES = {
    'alibaba cloud object storage service': 23,
    'amazon glacier': 53,
    'amazon s3': 2,
    'at&t synaptic storage': 10,
    'caringo castor': 51,
    'china mobile onest': 16,
    'ddn wos': 54,
    'dell dx object storage platform': 52,
    'emc atmos': 9,
    'google cloud storage': 19,
    'hds hitachi content platform': 12,
    'huawei object storage': 24,
    'inspur cloud object storage': 29,
    'microsoft azure storage': 3,
    'openstack object storage': 14,
    'oracle cloud infrastructure archive storage': 28,
    'oracle cloud infrastructure archive storage classic': 22,
    'oracle cloud infrastructure object storage': 26,
    'oracle cloud infrastructure object storage (s3 compatible)': 25,
    'oracle cloud infrastructure object storage classic': 28,
    'rackspace cloud files': 5,
    'telefonica open cloud object storage': 27,
    'verizon cloud storage': 18,
    'vmware vcloud air object storage': 20
}
DUMMY_DATA = {
    'dummy_data': 'dummy data for test case'
}

HYPERSCALE_CONSTANTS = {
    'vertical_scaleout_add_disk_success': 'configured',
    'Add_Bricks_Success': 'successfully added bricks to volume'
}

DEVICE_ACCESS_TYPES = {
    'WRITE': 2,
    'READ': 4,
    'READWRITE': 6,
    'PREFERRED': 8,
    'DATASERVER_IP': 16,
    'DATASERVER_SAN': 32,
    'CCM_READ_ONLY': 64,
    'DATASERVER_ISCSI': 128,
}