# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Helper file for maintaining deployment related Constants."""


import os
from AutomationUtils import constants

DEFAULT_DRIVE_LETTER = "C:"

UNIX_DEFAULT_DRIVE_LETTER = "/"

REMOTE_FILE_COPY_LOC = DEFAULT_DRIVE_LETTER + "\\AUTOMATION_LOC"

UNIX_REMOTE_FILE_COPY_LOC = UNIX_DEFAULT_DRIVE_LETTER + "AUTOMATION_LOC"

INTERACTIVE_INSTALL_EXE_PATH = os.path.join(constants.AUTOMATION_DIRECTORY, 'CompiledBins', 'interactiveinstall.exe')
"""str:        path where the interactiveinstall.exe binary is placed."""

REGISTER_ME_XML_OP = os.path.join(REMOTE_FILE_COPY_LOC, "registerme_output.xml")

FOREVERCELL_WORKFLOW_NAME = "Custom Install Package Creation - v11 - Create Package [SP9] - test"

FOREVERCELL_HOSTNAME = "cloud.commvault.com"

INSTALL_PLATFORMS = ['Windows', 'Mac']
''' Installation platforms supported for laptop testcases '''

PACKAGE_EXE_MAP = {
    "Mac": "macOS.pkg",
    "Windows": "WinX64.exe",
}

PACKAGES_TO_DOWNLOAD = {
    "File System Core Packages": {
        "macOS": "macOS.pkg",
        "Windows-x64": "WinX64.exe",
        "Windows-x86": "Win32.exe"
    }
}
# Commenting out temporarily unless some real case comes in future to install proxy packages.
#     "Proxy Packages":{
#         "Windows-x64": "WinX64_Proxy.exe",
#         "Windows-x86": "Win32_Proxy.exe"
#     }

CURRENT_RELEASE_VERSION = "11.0.0"

CURRENT_BUILD_VERSION = "BUILD80"

DOWNLOAD_CENTER_CATEGORY = "Custom Package"

DOWNLOAD_CENTER_SUB_CATEGORY = "Packages"

PROXY_GROUP_NAME = 'Infrastructure - MSP Proxies (DMZ)'

PROXY_DEFAULT_PORT = '443'

EXCLUDE_FOLDERS = [
    "CVS",
    "ThirdParty",
    "LooseUpdates",
    "1",
    "14",
    "16",
    "101",
    "105",
    "106",
    "107",
    "108",
    "110",
    "111",
    "112",
    "113",
    "114",
    "115",
    "LaptopVPNPackages",
    "LaptopPackages",
    "RootFiles",
    "OEM",
    "OneTouch"]

SIM_CALL_WRAPPER_EXE = "SIMCallWrapper.exe"

QINSTALLER_RETURNCODES = {
    0: "SUCCESS",
    1: "FAILED",
    2: "CANCELED",
    3: "REBOOT_NEEDED",
    4: "LOGOFF_NEEDED",
    5: "REBOOT_AND_RESUME_NEEDED",
    6: "CLIENTNAME_CONFLICT",
    7: "NO_SRM_SERVER",
    8: "NO_LICENSE",
    9: "CS_HOST_NOT_RESOLVABLE",
    10: "INSTALL_FOLDER_NOT_EMPTY",
    11: "CLIENTNAME_IN_USE",
    12: "HOSTNAME_IN_USE",
    13: "UNFINISHED_INTERACTIVE_INSTALL_DETECTED",
    14: "PLATFORMS_NOT_ALLOWED",
    15: "UNFINISHED_INSTALL_DETECTED",
    16: "PORTS_IN_USE",
    17: "ALL_PLATFORMS_ALREADY_INSTALLED",
    18: "LOW_DISK_SPACE",
    19: "CLIENT_AUTHENTICATION_FAILED",
    20: "CLUSTER_VM_DETECTED",
    21: "FAILED_STOP_ORACLE_SERVICES",
    22: "ORACLE_SERVICES_RUNNING",
    23: "NO INSATTLED INSTANCE DETECTED",
    24: "SIM Operation Failed",
    25: "JOB IN PROGRESS",
    26: "PACKAGE_UPGRADE_NOT_ALLOWED",
    27: "REQUIRED_SERVICE_PACK_MISSING",
    28: "FAILED_TO_CREATE_APPLICATION",
    29: "FAILED_ENABLE_AUTHENTICATION_ALIAS",
    31: "MULTI_INSTANCE_NOT_ALLOWED",
    32: "LOW_MEMORY",
    33: "FailedStopDB2Services",
    34: "FailedStartOracleServices",
    35: "FailedStartDB2Services",
    36: "SearchIndexLocationPathNotValid",
    37: "InvalidSearchEnginePort",
    38: "SelectedPackagesAlreadyInstalled",
    39: "MissingPayload",
    40: "WrongCommandLine",
    41: "ExplorerPluginBinariesLocked",
    42: "FailedInstallThirdParty",
    43: "FailedInstallPackage",
    44: "FailedToStartServices",
    45: "FailedToExtractSEEFiles",
    46: "FailedToStopProcesses",
    47: "ConflictDiagUpdatesInCache",
    100: "AnotherInstanceRunning",
    125: "DBUpdateInstallFailed",
    126: "AlreadyUptoDate",
    127: "V8FWConfigDetected"
}

WINDOWS_SERVICES = {
    1: ['GxFWD'],
    20: ['GxEvMgrS', 'GxFWD', 'GxApM', 'GxQSDK', 'GxJobMgr', 'GxMLM'],
    23: ['GxWorkflowEngine', 'GxCVD'],
    25: ['GxApM'],
    51: ['GXMMM'],
    203: ['GxClMgrS'],
    252: ['GxClMgrS'],
    451: ['CvRepSvc'],
    552: ['GxFWD', 'GxClMgrS'],
    702: ['GxClMgrS'],
    713: ['GxBlr'],
    753: ['GxClMgrS']
}

UNIX_SERVICES = {
    1002: ['cvd'],
    1101: ['ClMgrS', 'cvlaunchd'],
    1301: ['CvMountd']
}

DOWNLOAD_SOFTWARE_DEFAULT_MEDIA = "CVMedia"
CURRENT_RELEASE_ID = 16
EXTRACT_BAT_FILE = "ExtractBootstrapper.bat"
DB2LOGLOCATION = r"C:\DB2logs"
BOOTSTRAPPER_EXECUTABLE_EXTRACTPATH = "BootStrapperExtractedPath"
UNIX_BOOTSTRAPPER_DOWNLOADPATH = "DownloadPackageLocationUnix\\Commvault"
WINDOWS_BOOTSTRAPPER_DOWNLOADPATH = "DownloadPackageLocationWindows\\Commvault"
UNIX_BOOTSTRAPPER_DOWNLOAD_OSID = [39, 28, 30, 14, 26, 29, 17, 18, 10, 11, 41]

WINDOWS_BOOTSTRAPPER_DOWNLOAD_OSID = [1, 3]
REMOTEFILECOPYLOC = "AUTOMATION_LOC\\"
BRANDING_DICT = {
    1: "Commvault",
    16: "Commvault Express",
    106: "Virtual Server"
}


def oemid_edition_name(oem_id):
    """
    returns Edition name for given OEMID
    """
    return BRANDING_DICT[int(oem_id)]


OSNAME_LIST = {
    0: ("windows", "ThirdPartyPackage", "ThirdPartyPackage"),
    1: ("windows32", "Windows", "Win32"),
    3: ("windowsX64", "WinX64", "WinX64"),
    14: ("aixos", "aix-ppc", "aix-ppc"),
    15: ("linuxos", "linux-x86", "linux-x86"),
    16: ("linuxosX64", "linux-x8664", "linux-x8664"),
    17: ("linuxosPPC64", "linux-ppc64", "linux-ppc64"),
    18: ("linuxosS390", "linux-s390", "linux-s390"),
    29: ("linuxs390os", "linux-s390-31", "linux-s390-31"),
    20: ("hpos", "hp-ia64", "hp-ia64"),
    30: ("solsparcos", "sol-sparc-x86", "sol-sparc-x86"),
    23: ("solarisosX64", "sol-x8664", "sol-x8664"),
    24: ("darwinos", "dwn-x86", "dwn-x86"),
    27: ("darwinosx8664", "dwn-x8664", "dwn-x8664"),
    25: ("freeBSDos", "fbsd-x86", "fbsd-x86"),
    26: ("freeBSDosX64", "fbsd-x8664", "fbsd-x8664"),
    31: ("solos", "sol-x86", "sol-x86"),
    28: ("aixppcos", "aix-ppc-32", "aix-ppc-32"),
    22: ("solarisos", "sol-sparc", "sol-sparc"),
    32: ("linuxosPPC64le", "linux-ppc64-le", "linux-ppc64-le"),
    33: ("aixos5232", "aix52-32", "aix52-32")
}

UNIX_ROOT_LIST = ["\\Unix\\cvpkgadd", "\\Unix\\cvpkgseed", "\\Unix\\detect", "\\Unix\\pkg.xml",
                  "\\Unix\\pkg.xml.description", "\\Unix\\silent_install", "\\Unix\\support",
                  "\\Unix\\version", "\\Unix\\linux-x8664\\BinaryInfo.xml",
                  "\\Unix\\linux-x8664\\BinaryInfo.xml.description"]

WIN_ROOT_LIST = ["\\Windows\\BinaryInfo.xml", "\\Windows\\BinaryInfo.xml.description"]

IGNORE_LIST = ["CVUpdates", "CVPackages", "DVDInfo.txt", "SPInfo.txt", "HotfixConfiguration.xml",
               "CUConfiguration", "LooseUpdates", "CVAppliance"]

EXCLUDE_OEM = [
    "\\101\\",
    "\\105\\",
    "\\106\\",
    "\\107\\",
    "\\108\\",
    "\\110\\",
    "\\111\\",
    "\\112\\",
    "\\113\\",
    "\\114\\",
    "\\115\\",
    "\\14\\",
    "\\16\\",
    "\\116\\"]

DOWNLOAD_WIN_IGNORE_LIST = ["\\MSSQL\\", "\\OEM\\", "\\BinaryInfo.xml", "\\BinaryInfo.xml.description"]
DOWNLOAD_UNIX_SKIP_LIST = ['cvpkgadd', 'cvpkgseed', 'detect', 'silent_install', 'support']

DO_NOT_DOWNLOAD_FROM_INSTALL_JOB = {
    "key": "UpdateFlags",
    "value": "bDoNotDownloadFromInstallJob",
    "data": "1",
    "reg_type": "DWord"
}