# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
""" It contains constants which will be used throughout the app."""
# Application type
APPTYPE_ALL = 100
APPTYPE_FILES = 33
APPTYPE_EMAILS = 54
# Permissions
SHARE_ADD_PERMISSION = 1
SHARE_DELETE_PERMISSION = 2
SHARE_EXECUTE_PERMISSION = 3
SHARE_VIEW_PERMISSION = 4
SHARE_ALL_PERMISSION = 5
SHARE_NO_PERMISSION = 6
# Set deletion range
DELETE_SELECTED = 1
DELETE_PAGE = 2
DELETE_ALL = 3
DELETE_SET = 4
# Exportset formats
PST = 1
CAB = 2
NSF = 3
HTML = 4
# SELECTION RANGE
SELECTED = 1
THIS_PAGE = 2
ALL = 3
# Job operation type
PRECHECK = "preoperation"
POSTCHECK = "postoperation"
# Custom names
QUERYSET = "Query Set"
EXPORTSET = "Export Set"
# Wait times & limits
RANDOM_INT_LOWER_LIMIT = 100
RANDOM_INT_UPPER_LIMIT = 100000
TWO_MINUTES = 1200
ONE_MINUTE = 60
# Violation
CHARS_NOT_ALLOWED_IN_SETNAME = "/\\:*?\"<>|@;&^()%#+"
# Set names
NUM_CHARS = 5
NUM_DIGITS = 2
# Set names
QUERYSET_NAME_PREFIX = "qs"
QUERY_NAME_FORMAT = "query"

# Content Extraction Constants
CE_SERVICE_NAME = "CVContentPreview(Instance001)"
EXTRACTOR_THREAD_TIME_OUT = "extractorThreadTimeout"
CA_REGISTRY = "ContentAnalyzer"

# Registry types
REG_DWORD = "DWord"

# Index server constants
ANALYTICS_SERVICE_NAME = "CVAnalytics(Instance001)"
QUERY_EXTRACTOR_TIME_OUT_DOCS = {"IsFile": 1, "ErrorMessage": "\"Entity extraction request timed out\""}
QUERY_CVSTUB_CRITERIA = {"IsStub": 1}
QUERY_NON_STUB_FILE_CRITERIA = {"IsStub": 0, "IsFile": 1}
QUERY_FILE_CRITERIA = {"IsFile": 1}
QUERY_FOLDER_CRITERIA = {"IsFolder": 1}
QUERY_CISTATE_SUCCESS = {"cistate": 1}
QUERY_CISTATE_SKIPPED = {"cistate": 17}
QUERY_CISTATE_DELETE = {"cistate": 3334}
QUERY_CASTATE_SUCCESS = {"CAState": 1}
QUERY_CASTATE_FAILED = {"CAState": 0}
QUERY_100_ROWS = {"rows": 100}
QUERY_ZERO_ROWS = {"rows": 0}
NUM_FOUND_PARAM = "numFound"
RESPONSE_PARAM = "response"
DOCS_PARAM = "docs"
STATS_PARAM = "stats"
STATS_FIELD_SET_PARAM = "stats.field"
STATS_FIELD_PARAM = "stats_fields"
FACET_PARAM = "facet"
FACET_FIELD_SET_PARAM = "facet.field"
FACET_FIELDS_PARAM = "facet_fields"
FACET_COUNTS_PARAM = "facet_counts"
MIN_PARAM = 'min'
MAX_PARAM = 'max'
MEAN_PARAM = 'mean'
COUNT_PARAM = "count"
ROWS_PARAM = "rows"
FIELD_FILE_EXTENSION = "FileExtension"
FIELD_EXTRACT_DURATION = "extractedDuration_i"
FIELD_JOB_ID = "JobId"
FIELD_MODIFIED_TIME = "ModifiedTime"
FIELD_URL = "Url_sort"
FIELD_CONTENT = "content"
SKIP_FOLDER_CHECK = -1
SOLR_DATE_STRING = "%Y-%m-%dT%H:%M:%SZ"
ANALYTICS_PROCESS_NAME = 'DataCube'
ANALYTICS_REG_KEY = 'Analytics'
ANALYTICS_DIR_REG_KEY = 'analyticsDataDir'
SOLR_JVM_MEMORY_REG_KEY = 'JvmMx'
SOLR_JVM_MEMORY_REG_KEY_PATH = 'HKLM:\\SOFTWARE\\Wow6432Node\\Apache Software Foundation\\Procrun 2.0\\' \
                               'CVAnalytics(Instance001)\\Parameters\\Java'
BACKUP_INDEX_DIR = 'Index'
BACKUP_CONF_DIR = 'Config'
BACKUP_CONF_SETS = 'configsets'
BACKUP_CONF_HOME = 'confHome'
DATA_ANALYTICS_DEFAULT_CORES = [
    'cvcoreaudit0',
    'cvcoreaudit1',
    'cvcoreaudit2',
    'cvcoreaudit3',
    'cvcorefla0',
    'cvcorefla1',
    'cvcorefla2',
    'cvcorefla3',
    'cvcorefla4',
    'cvcorefla5',
    'cvcorefla6',
    'cvcorefla7']
SYSTEM_DEFAULT_CORES = [
    'indexserverinfo',
    'cvemptyshard',
    'datasourceinfo'
]
DATA_ANALYTICS_DYNAMIC_CORES = ['DC_']

# DataCube Constants
FILE_SYSTEM_DSTYPE = "5"
OPEN_DATASOURCE_DSTYPE = "11"
OPEN_DS_PREFIX = "DC_open_"
FILE_DS_PREFIX = "DC_file_"
ENTITY_EXTRACTION_PROPERTY = ['iscaenabled', 'caconfig', 'cacloudid']
ENTITY_EXTRACTION_ENABLED = 'iscaenabled'
ENTITY_EXTRACTION_CONFIG = 'caconfig'
ENTITY_EXTRACTION_CLOUDID = 'cacloudid'
OPEN_DS_PROPERTY = ['candelete', 'appname']
OPEN_DS_PROPERTY_VALUES = ["true", "DATACUBE"]
OPEN_DS_PROPERTIES = [{"propertyName": OPEN_DS_PROPERTY[x], "propertyValue": OPEN_DS_PROPERTY_VALUES[x]}
                      for x in range(0, len(OPEN_DS_PROPERTY))]
FILE_DS_EE_COLUMN = ["content"]
FILE_DS_DYNAMIC_PROPERTY = [
    'createclient',
    'candelete',
    'appname',
    'includedirectoriespath',
    'doincrementalscan',
    'username',
    'password',
    'pushonlymetadata',
    'accessnodeclientid',
    'excludefilters',
    'minumumdocumentsize',
    'maximumdocumentsize',
    'includefilters'
]
FILE_DS_INCLUDE_FILE_TYPES = "*.doc, *.docx, *.xls, *.xlsx, *.ppt, *.pptx, *.msg, *.txt, *.rtf, *.eml, *.pdf, " \
                             "*.htm, *.html, *.jpg, *.png, *.jpeg, *.xml, *.csv, *.log, *.ods, *.odt, *.odg, " \
                             "*.odp, *.dot, *.pages, *.bmp, *.xmind"
FILE_DS_DYNAMIC_PROPERTY_VALUES = [
    "archiverClient",
    "true",
    "DATACUBE",
    "",
    "false",
    "",
    "",
    "true",
    "",
    "",
    "0",
    "52428800",
    FILE_DS_INCLUDE_FILE_TYPES
]
SCHEMA_FIELDS = {
    "fieldName": "",
    "type": "string",
    "indexed": True,
    "stored": True,
    "multiValued": False,
    "searchDefault": True,
    "autocomplete": False
}
VIEW_PERMISSION = 201
EDIT_PERMISSION = 202
EXECUTE_PERMISSION = 204
SHARE_PERMISSION = 107
USER_ASSOCIATION_TYPE = 13
SHARE_ADD = 2
SHARE_DELETE = 3
SOLR_FETCH_ONE_ROW = "rows=1"
SOLR_FETCH_HUNDRED_ROW = "rows=100"
ENTITY_EXTRACTION_JSON_PROP = [
    'EntityExtractionRER',
    'EntityExtractionNER',
    'EntityExtractionDE',
    'EntityExtractionFields']

# Activate Entity Names
ENTITY_EMAIL = "Email"
ENTITY_PHONE = "Phone Number"
ENTITY_IP = "IP Address"
ENTITY_CREDIT_CARD = "CreditCard"
ENTITY_SSN = "SSN"
ENTITY_PERSON = "Person"
ENTITY_AUTOMATION = "AutomationFreshCADate"
ENTITY_AUTOMATION_KEYWORDS = "date"
ENTITY_AUTOMATION_REGEX = "(?:[0-9]{4}-[0-9]{2}-[0-9]{2})"

# Activate Column/Entity Names for advance search
ADVANCE_SEARCH_FIELDS = [
    "Credit card number",
    "US Social Security number",
    "IP address",
    "US Passport",
    "US Individual Taxpayer Identification Number",
    "Email",
    "US Driver License",
    "Sentiment tags",
    "Routing Transit Number",
    "File name",
    "File Path",
    "Column",
    "Subject",
    "To",
    "From",
    "CC",
    "Mailbox",
    "Folder",
    "Body",
    "Attachment"
]

# Sqlite DB constants for generated PII data
DB_ENTITY_DELIMITER = "****"
DB_COLUMN_NAMES = [
    'Credit Card Number',
    'US Social Security number',
    'IP Address',
    'PASSPORT',
    'US Individual Taxpayer Identification Number',
    'Email',
    'DL',
    'Sentiment tags',
    'Routing transit number',
    "FileName",
    "FilePath",
    "Column",
    "Subject",
    "To_Mail",
    "From_Mail",
    "CC",
    "Mailbox",
    "Folder",
    "SearchText",
    "Attachment"
]
DB_COLUMN_TO_KEY = [
    'entity_ccn',
    'entity_ssn',
    'entity_ip',
    'entity_us_passport',
    'entity_itin',
    'entity_email',
    'entity_usdl',
    'entity_finance_tags',
    'entity_rtn',
    "FileName_idx",
    "Url_idx",
    "Column_idx",
    "Subject_idx"
]

# Activate Entity Key-solr field mappings
ENTITY_KEY_EMAIL = "entity_email"
ENTITY_KEY_PHONE = "entity_phone"
ENTITY_KEY_IP = "entity_ip"
ENTITY_KEY_CREDIT_CARD = "entity_ccn"
ENTITY_KEY_SSN = "entity_ssn"
ENTITY_KEY_PERSON = "entity_person"
ENTITY_KEY_AUTOMATION = "entity_automationfreshcadate"

# Activate Data Source Names
ONE_DRIVE = "OneDrive"
EXCHANGE = "Exchange"
DATABASE = "Database"
FILE_SYSTEM = "File system"
GOOGLE_DRIVE = "Google Drive"
GMAIL = "Gmail"
SHAREPOINT = "SharePoint"

# Data Source to GDPR DB column field mapping for advance search output
ADVANCE_SEARCH_DB_OUTPUT_FIELD = {
    ONE_DRIVE: 'FileName',
    EXCHANGE: 'Subject',
    FILE_SYSTEM: 'FilePath',
    GOOGLE_DRIVE: 'FileName',
    DATABASE: 'Column'
}

# DB Field to Group Exchange Advance Search Output
EXCHANGE_MAILBOX_DB_FIELD = "Mailbox"
EXCHANGE_ATTACHMENT_MAILBOXES_FIELD = "AttachmentMailboxes"
DB_SEARCH_TEXT_FIELD = "SearchText"

# Country Name
USA_COUNTRY_NAME = "United States"

# FSO Subclient Properties
FSO_SUBCLIENT_PROPS = {
    "fsSubClientProp": {
        "catalogACL": True,
        "catalogAdditional": True,
        "preserveFileAccessTime": True,
        "scanOption": 1
    }
}
# Search Categories used while adding a file server
CLIENT_NAME = "Client name"
HOST_NAME = "Host name"

# Job constants
JOB_WITH_ERROR = 'completed w/ one or more errors'
JOB_COMPLETE = 'completed'

# Powershell file constants
DENY = 'Deny'
FULL_CONTROL = 'FullControl'

# TPPM constants
CLIENT_ENTITY_ID = 3
TPPM_TYPE = 9

# Classifier Constants
TRAIN_STATUS_COMPLETED = "Completed"
TRAIN_STATUS_FAILED = "Failed"
TRAIN_STATUS_NOT_READY = "Not ready"
DONUT_CHART_NAME = 'Classifier'
CLASSIFIER_ML_API = 'http://localhost:5004/api/2.0/mlflow/experiments/get-by-name?experiment_name='
CLASSIFIER_SOLR_DATASET_ENTITY_QUERY = 'http://localhost:22000/solr/datasets/select?q=entity_id:'
CLASSIFIER_SOLR_DATASET_INFO_ENTITY_QUERY = 'http://localhost:22000/solr/datasets_info/select?q=entity_id:'
CLASSIFIER_ENTITY_TYPE = 4
CLASSIFIER_ARTIFACT_LOCATION = 'artifact_location'
CLASSIFIER_EXPERIMENT = 'experiment'
CLASSIFIER_ATTRIBUTE_TRAINING_STATUS = 'trainingStatus'
CLASSIFIER_ATTRIBUTE_MODEL_GUID = 'modelGUID'
CLASSIFIER_ATTRIBUTE_MODEL_URI = 'modelURI'
CLASSIFIER_ATTRIBUTE_CA_USED = 'CAUsedInTraining'
CLASSIFIER_ATTRIBUTE_SYNC_CA = 'syncedContentAnalyzers'
CLASSIFIER_ATTRIBUTE_CLIENTID = 'clientId'
CLASSIFIER_ATTRIBUTE_LAST_MODEL_TRAIN_TIME = 'lastModelTrainTime'
CLASSIFIER_DETAILS_JSON_NODE = 'classifierDetails'
CLASSIFIER_SYNC_CA_LIST_JSON_NODE = 'contentAnalyzerList'
CLASSIFIER_ENTITY_ID = 'entity_id'
