# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

    tear_down()     --  tear down function of this test case

"""

from AutomationUtils import constants
from AutomationUtils.cvtestcase import CVTestCase


class TestCase(CVTestCase):
    """Class for executing this test case"""

    def __init__(self):
        """Initializes test case class object

            Properties to be initialized:

                name            (str)       --  name of this test case

                tcinputs        (dict)      --  test case inputs with input name as dict key
                                                and value as input type

        """
        super(TestCase, self).__init__()
        self.name = "TEST_CASE_NAME"
        self.tcinputs = {
            "INPUT_1": None,
            "INPUT_2": None
        }

    def setup(self):
        """Setup function of this test case"""
        pass

    def run(self):
        """Run function of this test case"""
        try:
            # Run FULL backup
            job = self.subclient.backup("FULL")

            if not job.wait_for_completion():
                raise Exception(
                    "Failed to run FULL backup with error: {0}".format(job.delay_reason)
                )
            self.log.info("Backup job: %s completed successfully", job.job_id)

        except Exception as exp:
            self.log.error('Failed to execute test case with error: %s', exp)
            self.result_string = str(exp)
            self.status = constants.FAILED

    def tear_down(self):
        """Tear down function of this test case"""
        pass
