from os.path import dirname, basename, isfile, join
import glob
from enum import Enum

# This will load all modules within the tasks directory and create an enum from them to be used throughout the code.
modules = glob.glob(join(dirname(__file__), "*.py"))
__all__ = [basename(f)[:-3] for f in modules if isfile(f) and not f.endswith('__init__.py')]
TaskType = Enum('TaskType', __all__)