# python import

# project import
from cvmanager_task_arg import TaskArg
import cvmanager_task
import cvmanager_task_step


class Task(cvmanager_task.TaskObject):
    """ Stand alone node upgrade is just basic remote node upgrade.  We launch all in parallel as the stand alone
    nodes can simply be upgraded.  We don't have to worry about breaking them, its all or nothing when they are
    in this non-gluster mode.

    """
    task_args = {
            'nodes': TaskArg('nodes', list)
        }

    @cvmanager_task_step.TaskStep
    def upgrade_nodes(self, *args, **kwargs):
        # For stand alone nodes, just run them in parallel and don't do any additional processing, for now.
        remote_upgrades = []
        for node in self.kwargs.get("nodes", []):
            if node.local_node:
                # There can only be 1 local node or something went really wrong.
                self.create_child_task('Upgrade_Node', launch=True, **self.kwargs)
            else:
                remote_upgrades.append(self.create_remote_child_task('Upgrade_Node', node.hostname, launch=False,
                                                                     **self.kwargs))

        # Wait for the remote nodes, and local node.
        self.wait_for_remote_processes(remote_upgrades, launch=True)
        self.wait_for_child_task()
        return self.check_and_return_remote_processes_status(remote_upgrades)

    def set_process(self, process):
        process.main_process = [
            self.upgrade_nodes
        ]
