import wrappers

# Project imports
import cvmanager_task_step
import cvmanager_task
from cvmanager_task_arg import TaskArg


class Task(cvmanager_task.TaskObject):
    task_args = {
        'arg1': TaskArg('arg1', bool, default_value=True),
        'arg2': TaskArg('arg2', str, required=True, default_value=wrappers.get_hostname())
    }

    def set_process(self, process_object):
        # This is simply a list of steps for this Task.
        process_object.main_process = [
            self.basic_step
        ]

    @cvmanager_task_step.TaskStep
    def basic_step(self, *args, **kwargs):
        task = self.create_child_task('Template_Child', launch=True, **self.kwargs)

        # Launch and wait for the tasks to complete.
        task.wait_for_child_task()
        return_code = task.check_and_return_child_task_status()
        if not return_code:
            self.log.error("Failed running the child task [{0}].".format(self.kwargs['arg2']))

        return return_code
