# Python imports

# Project imports
from task_manager import cvmanager_task_step
from task_manager import cvmanager_task
import wrappers


class Task(cvmanager_task.TaskObject):
    @cvmanager_task_step.TaskStep
    def create_command_file(self, *args, **kwargs):
        with open("/tmp/cvavahi_command_{0}".format(self.uid), "w+") as cmd_file:
            cmd_file.write("upgrade_os find_missing_rpms " + self.kwargs['node_name'])
        return True

    @cvmanager_task_step.TaskStep
    def copy_command_to_node(self, *args, **kwargs):
        # EVERY decorated TaskStep must return True OR False...this tells the manager to continue or not.
        cmd = "/usr/local/bin/arch write-file {0} /tmp/cvavahi_command_{1} /tmp/cvavahi_command".format(
            self.kwargs['node_name'], self.uid)
        ret = wrappers.waitsystem(cmd)
        if ret:
            self.log.error("Command: [%s}" % cmd)
            self.log.error("Failed to execute command ... ret[%d]" % ret)
            return False

        return True

    @cvmanager_task_step.TaskStep
    def run_command_remote(self, *args, **kwargs):
        # EVERY decorated TaskStep must return True OR False...this tells the manager to continue or not.
        cmd = "/usr/local/bin/arch manage commvault execute " + self.kwargs['node_name'] + \
              " cvavahi.py /tmp/cvavahi_command"
        ret = wrappers.waitsystem(cmd)
        if ret:
            self.log.error("Command: [%s}" % cmd)
            self.log.error("Failed to execute command... ret[%d]" % ret)
            return False

        return True

    def set_process(self, process_object):
        # This is simply a list of steps for this Task.

        # You can set or just completely leave out.
        process_object.main_process = [
            self.create_command_file,
            self.copy_command_to_node,
            self.run_command_remote
        ]
