# Python imports
import os

# Project imports
import common
import cvmanager_task_step
import cvmanager_task
import cvmanager_defines
import cvupgrade_common
import wrappers
import cvmanager_task_arg
import cvmanager_spinner


class Task(cvmanager_task.TaskObject):
    """ This task is designed to populate a software cache without using the download software job.
    """
    task_args = {
        'payload-loc': cvmanager_task_arg.TaskArg('payload-loc', str, required=True),
        'nodes': cvmanager_task_arg.TaskArg('nodes', list)  # These are passed through to Query_RPM task.
     }

    @cvmanager_task_step.TaskStep
    def query_rpm(self, *args, **kwargs):
        """  Using the required option of payload-loc, create the tmpcvrepo on this machine.
        /ws/ddb/cvmanager/tmpcvrepo

        :param args:
        :param kwargs:
        :return:
        """
        query_task = self.create_child_task('Query_RPM', **self.kwargs)
        query_task.wait_for_child_task()

        return query_task.check_and_return_child_task_status()

    @cvmanager_task_step.TaskStep
    def copy_rpms(self, *args, **kwargs):
        """ Copy the RPMS from the temporary repo which Query_RPM generated, to the software cache.

        :param args:
        :param kwargs:
        :return:
        """
        sw_cache_loc = cvupgrade_common.def_swcache_loc  # /opt/commvault/SoftwareCache
        wrappers.rmdir(sw_cache_loc)

        version = "rhel-" + cvupgrade_common.get_rhel_version_v2(cvmanager_defines.NFS_SHARE_TMP_REPO_DIR)
        cache_rpm_loc = os.path.join(sw_cache_loc,"CVAppliance", "Unix", version)

        self.log.info(
            "Copying RPM packages from [{0}] to [{1}]. This may take some time.".format(
                self.kwargs.get('payload-loc'), cache_rpm_loc))

        payload_rpm_source = os.path.join(self.kwargs.get('payload-loc'), 'CVAppliance', 'Unix', version)

        return cvmanager_spinner.dot_fast(cvupgrade_common.copy_rpms, cvmanager_defines.UPGRADE_XML,
                                          payload_rpm_source, cache_rpm_loc)

    @cvmanager_task_step.TaskStep
    def clean_registry(self, *args, **kwargs):
        common.deleteregistryentry(cvmanager_defines.REG_MA_KEY, "sHyperScalePayloadDir")
        return True

    def set_process(self, process):
        process.main_process = [
            self.query_rpm,
            self.copy_rpms
        ]
        process.post_process = [
            self.clean_registry
        ]
