# Python imports

# Project imports
import cvmanager_task_step
import cvmanager_task
import cvcluster
import task_defines


class Task(cvmanager_task.TaskObject):
    @cvmanager_task_step.TaskStep
    def step1(self, *args, **kwargs):
        return True

    @cvmanager_task_step.TaskStep
    def step2(self, *args, **kwargs):
        return task_defines.StepStatus.REBOOT_AND_RESUME

    @cvmanager_task_step.TaskStep
    def step3(self, *args, **kwargs):
        return True

    @cvmanager_task_step.TaskStep
    def get_remote_nodes(self, *args, **kwargs):
        import time
        #time.sleep(10)
        remote_nodes = cvcluster.get_remote_nodes()
        setattr(self, 'remote_nodes', remote_nodes)
        return True

    def set_process(self, process_object):
        process_object.pre_process = [
            self.get_remote_nodes
        ]

        process_object.main_process = [
            self.step1,
            self.step2,
            self.step3
        ]
