# Python imports
from enum import Enum

# Project imports
from tasks import TaskType


class ProcessStatusCode(Enum):
    # These are OVERALL Task statuses used and saved in JSON.
    SUCCESS = 0
    FAILED = 1
    RESUME_AFTER_REBOOT = 2
    NOT_STARTED = 3
    RUNNING = 4
    FAILED_INITIALIZATION = 5
    RESUMING = 6
    DUPLICATE_TASK = 7
    INITIALIZED = 8


class StepStatus(Enum):
    NOT_ATTEMPTED = 0
    RUNNING = 1
    PASSED = 2
    FAILED = 3
    SKIPPED = 4
    INITIALIZED = 5
    REBOOT_AND_RESUME = 6
    EXCEPTION = 7


class StepStates(Enum):
    RUNNING = [StepStatus.RUNNING, StepStatus.INITIALIZED]
    NOT_RUNNING = [StepStatus.NOT_ATTEMPTED, StepStatus.PASSED, StepStatus.FAILED, StepStatus.SKIPPED]


class StatusStates(Enum):
    READY = [ProcessStatusCode.NOT_STARTED, ProcessStatusCode.RESUME_AFTER_REBOOT, ProcessStatusCode.RESUMING, ProcessStatusCode.INITIALIZED]
    NOT_READY = [ProcessStatusCode.SUCCESS, ProcessStatusCode.FAILED, ProcessStatusCode.RUNNING, ProcessStatusCode.FAILED_INITIALIZATION,
                 ProcessStatusCode.DUPLICATE_TASK]


PROC_PRE = 'pre_process'
PROC_MAIN = 'main_process'
PROC_POST = 'post_process'

TASK_POLL_INTERVAL = 1
STATUS_FILE_RELOAD_THREAD = 2
STATUS_CONSOLE_REFRESH = 2
LOCAL_TASK_TIMEOUT = 18000
REMOTE_TASK_TIMEOUT = 18000


# KEYS USED BETWEEN TASKS
NFS_HOST = 'nfs_host'
NFS_MOUNT = 'nfs_mount'
