# Python imports
import os

# Project imports
import cvmanager_defines
import cvmanager_logging
import wrappers


class XMLRequest(object):
    def __init__(self, request, **kwargs):
        self.log = cvmanager_logging.get_log()
        self.kwargs = kwargs
        self.request = request

    def __make_request(self, input_xml_file):
        command_line = '/opt/commvault/Base/qoperation execute -af {0} '.format(input_xml_file)

        for k, v in self.kwargs.items():
            command_line += '-{0} "{1}" '.format(k, v)

        if not wrappers.waitsystem(command_line) == 0:
            return False
        return True

    def execute(self):
        xml_file = os.path.join(cvmanager_defines.XML_REQUEST_DIR, self.request + '.xml')
        if not os.path.exists(xml_file):
            self.log.error("No xml request exists for [{0}].".format(self.request))
            return False

        return self.__make_request(xml_file)
