#! /usr/bin/env python

import os
import sys
import argparse
import json

CV_MGR_ROOT = os.path.abspath(os.path.join(os.sep, 'ws', 'ddb', 'cvmanager'))
CATALOG_DIR = os.path.join(CV_MGR_ROOT, 'catalog')
CVMANAGER_EXIT_CODE_STATUS = os.path.join(CATALOG_DIR, 'job_status.json')


def main():
    print("Getting the job status for workflow.")

    parser = argparse.ArgumentParser()
    parser.add_argument("-j", "--job_id", help="Workflow job id to get the status of.", dest='job_id', default=False)
    args = parser.parse_args()

    if not os.path.exists(CVMANAGER_EXIT_CODE_STATUS):
        sys.exit(999)

    with open(CVMANAGER_EXIT_CODE_STATUS, 'r') as in_file:
        json_data = json.load(in_file)

    # Update this job id.
    if not args.job_id:
        print("No job ID supplied, return full JSON.  If you want a specific job id, use the -j command line option.")
        print(json_data)
        sys.exit(0)

    if args.job_id in json_data:
        exit_code = json_data[args.job_id].get('exit_code', '999')
        sys.exit(exit_code)

    sys.exit(999)


if __name__ == "__main__":
    main()
