class TaskArg(object):
    def __init__(self, name, arg_type, default_value=None, required=False, valid_values=[], skip_validation=False,
                 description=None):
        self.name = name
        self.arg_type = arg_type
        if required and default_value is not None:
            # This is not really required, because we have a default value!
            self.required = False
        else:
            self.required = required
        self.valid_values = valid_values
        self.default_value = default_value
        self.skip_validation = skip_validation
        self.description = description

    def get_help(self):
        if self.required:
            required = 'True'
        else:
            required = 'False'

        if isinstance(self.default_value, bool):
            if self.default_value:
                def_val = 'True'
            else:
                def_val = 'False'
        else:
            def_val = self.default_value

        return [self.name, self.arg_type, required, def_val, self.valid_values, self.description]


def display_task_help(task_name):
    import cvmanager_task

    try:
        task_file = cvmanager_task.TaskObject.locate_task_file(task_name)
    except Exception as excp:
        print("This task has no defined options required, and does not require any inputs for proper execution.")
    else:
        args = task_file.Task.task_args
        if not isinstance(args, dict):
            print("This task has no defined options required, and does not require any inputs for proper execution.")
            return

        print("\nNOTE: If an option is required, but has a default value, it's not explicitly required to be "
              "specified on the command line.\n")
        print("To use these options, add them on the command after all other arguments, specifically the -t argument"
              " in the form of <option>=<value>.\nExample:"
              "\tcvmanager.py -t Task list_of_something=['item1','item2','item3'] test=False\n"
              "Alternatively, these options can be directly specified in the input yaml mode instead.\n")

        headers = ["Option", "Type", "Required", "Default Value", "Valid Values", "Description"]
        row_format = "{:<30}" * (len(headers))
        print(row_format.format(*headers))
        print("\n")
        for task_arg in args.values():
            print(row_format.format(*task_arg.get_help()))


class CommonArg(object):
    # With this argument, the task manager exit code will always be 0 regardless of task real code.
    EXIT_ONLY_TRUE = TaskArg('exit_only_true', bool, default_value=True)

    # Do not resume failed task, always start over from beginning.
    DO_NOT_RESUME = TaskArg('do_not_resume', bool, default_value=True)

    # Do not save the task status file.  Without status file, a fresh execution will happen every time.
    DO_NOT_SAVE = TaskArg('do_not_save', bool, default_value=True)

    # Do not save the task status file.  Without status file, a fresh execution will happen every time.
    USE_AVAHI = TaskArg('use_avahi', bool, default_value=True)
