# Python imports
from threading import Thread

# Project imports
import cvmanager_utils
import cvmanager_logging

LOG = cvmanager_logging.get_log()


class RemoteCommandReboot(object):
    def __init__(self, remote_command_list):
        self.remote_commands = remote_command_list
        self.log = LOG

    def __wait_for_node_reboot(self, timeout):
        node_status = {}
        threads = []
        for remote_command in self.remote_commands:
            node_status[remote_command.remote_hostname] = False
            thread = Thread(target=remote_command.wait_for_reboot, args=(node_status,))
            thread.daemon = True
            thread.start()

            threads.append(thread)

        cvmanager_utils.timed_join_all(threads, timeout)

        if not all([status for status in node_status.values()]):
            self.log.error("Failed rebooting node(s) [{0}].".format(
                ','.join(node for node, value in node_status.items() if not value)))
            return False

        return True

    def wait_for_reboot(self, timeout=1200):
        """

        :param timeout: int - Amount of time given to each thread to complete.
        :return:
        """
        # Wait for all required remote nodes to reboot
        if not self.__wait_for_node_reboot(timeout):
            return False

        return True
