# Python imports
import threading

# Project imports
import task_defines


class Process(threading.Thread):
    """ This is the task thread.  Whatever task needs to run in a thread will be run here.

    """
    @property
    def manager(self):
        return self._manager

    @manager.setter
    def manager(self, value):
        self._manager = value

    def __init__(self, group=None, target=None, name=None,
                 args=(), kwargs=None, verbose=None):
        super(Process, self).__init__()
        self.daemon = True

        # This manager is the main program upgrade manager.
        self._manager = kwargs['manager']

        self.log_it = getattr(kwargs, 'log_it', True)

    def run(self):
        """This will process tasks as a whole.
        """
        log = self.manager.log
        task = None
        try:
            queue = self.manager.queue
            if self.log_it:
                # Start a new thread to operate on the queue, this is used for child tasks where we always want to run
                log.debug("Starting task worker thread [{0}].".format(self.name))

            while True:
                task = queue.get()

                # Run the TaskProcess of this task.
                task.run_task()

                if self.log_it:
                    log.info("Completed [{0}] worker thread with code [{1}].".format(str(task.display_tree),
                                                                                     task.process.status_code.value))

                break
        except Exception, err:
            log.exception(str(err))
        finally:
            # Check the task status and set the return code
            if task:
                if task.kwargs.get('exit_only_true', False):
                    # If the task has this flag,
                    log.info("Task has exit_only_true flag specified, so task will always return success.")
                    task.manager.exit_code = task_defines.ProcessStatusCode.SUCCESS.value
                else:
                    task.manager.exit_code = task.process.status_code.value
            queue.task_done()
